import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1041
        self.name = "isRobotBounded"
        self.description = 'On an infinite plane, a robot initially stands at (0, 0) and faces north."G": go straight 1 unit. "L": turn 90 degrees to the left. "R": turn 90 degrees to the right. Return True if and only if there exists a circle in the plane such that the robot never leaves the circle.'
        self.url = "https://leetcode.com/problems/robot-bounded-in-circle/description/"
        
        self.rule = '''
def isRobotBounded(self, instructions: str) -> bool:
    diriction = 0
    place = [0,0,0,0]
    instructions = list(instructions)
    while instructions:
        instruction = instructions.pop(0)
        if instruction == 'G':
            place[diriction] += 1
        elif instruction == 'L':
            diriction = (diriction+3)%4
        elif instruction == 'R':
            diriction = (diriction+5)%4
    if place[0] == place[2] and place[1] == place[3] or diriction != 0:
        return True
    else:
        return False'''
        self.initialize = '''
1. Initialize
```
direction = 0
```
```
place = [0,0,0,0]
```
```
instructions = list(instructions)
```
instructions = {}
```

2. Main loop'''
        self.interation_one_in = '''
2.{} one interation
```
while instructions:
```
instructions = {}
enter
```
instruction = instructions.pop(0)
```
instruction = '{}'
```
if instruction == 'G':
```
instruction = '{}'
instruction == 'G'
enter
```
place[diriction] += 1
```
place[{}] = {}
```'''
        self.interation_one_not_in = '''
2.{} one interation
```
while instructions:
```
instructions = {}
enter
```
instruction = instructions.pop(0)
```
instruction = '{}'
```
if instruction == 'G':
```
instruction = '{}'
instruction != 'G'
not enter'''
        self.interation_two_in = '''
```
elif instruction == 'L':
```
instruction = '{}'
instruction == 'L'
enter
```
diriction = (diriction+3)%4
```
diriction = {}
```'''
        self.interation_two_not_in = '''
```
elif instruction == 'L':
```
instruction = '{}'
instruction != 'L'
not enter'''
        self.interation_three_in = '''
```
elif instruction == 'R':
```
instruction = '{}'
instruction == 'R'
enter
```
diriction = (diriction+5)%4
```
diriction = {}
```'''
        self.interation_three_not_in = '''
```
elif instruction == 'R':
```
instruction = '{}'
instruction != 'R'
not enter'''
        self.return_result_true= '''
3. return result
```
if place[0] == place[2] and place[1] == place[3] or diriction != 0:
```
place[0] = {}
place[2] = {}
place[1] = {}
place[3] = {}
diriction = {}
place[0] == place[2] and place[1] == place[3] or diriction != 0
enter
```
return True
```
So the answer is True.'''
        self.not_enter_loop = '''
2.{} one interation
```
while instructions:
```
instructions = {}
not enter'''
        self.return_result_false = '''
3. return result
```
if place[0] == place[2] and place[1] == place[3] or diriction != 0:
```
place[0] = {}
place[2] = {}
place[1] = {}
place[3] = {}
diriction = {}
place[0] != place[2] or place[1] != place[3] and diriction == 0
not enter
```
return False
```
So the answer is False.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        instructions = ''.join([random.choice(['G','L','R']) for _ in range(length)])
        question = f'''instructions = "{instructions}". "G": go straight 1 unit. "L": turn 90 degrees to the left. "R": turn 90 degrees to the right. Return True if and only if there exists a circle in the plane such that the robot never leaves the circle.'''
        return {"question": question,
                "instructions": instructions}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        instructions = data["instructions"]
        diriction = 0
        place = [0,0,0,0]
        instructions = list(instructions)
        output = self.initialize.format(instructions)
        i = 1
        while instructions:
            instructions_copy = deepcopy(instructions)
            instruction = instructions.pop(0)
            if instruction == 'G':
                place[diriction] += 1
                output += self.interation_one_in.format(i,instructions_copy,instruction,instruction,diriction,place[diriction])
            else:
                output += self.interation_one_not_in.format(i,instructions_copy,instruction,instruction)
            if instruction == 'L':
                diriction = (diriction+3)%4
                output += self.interation_two_in.format(instruction,diriction)
            else:
                output += self.interation_two_not_in.format(instruction)
            if instruction == 'R':
                diriction = (diriction+5)%4
                output += self.interation_three_in.format(instruction,diriction)
                answer = True
            else:
                output += self.interation_three_not_in.format(instruction)
                answer = False
        if not instructions:
            output += self.not_enter_loop.format(i,instructions)
        if place[0] == place[2] and place[1] == place[3] or diriction != 0:
            output += self.return_result_true.format(place[0],place[2],place[1],place[3],diriction)
            answer = True
        else:
            output += self.return_result_false.format(place[0],place[2],place[1],place[3],diriction)
            answer = False
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/1041.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))