import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1275
        self.name = "Tic_Tac_Toe_Game"
        self.description = '''A play Tic Tac Toe Game with B. A started first. Who's the winner of the Tic Tac Toe Game?'''
        self.url = '''https://leetcode.com/problems/find-winner-on-a-tic-tac-toe-game/description/'''
        self.rule = '''
def Tic_Tac_Toe_Game(moves: list[list]) -> str:
    matrix = [[''for _ in range(3)] for _ in range(3)]
    for i in range(len(moves)):
        if i % 2 == 0:
            matrix[moves[i][0]][moves[i][1]] = 'X'
        else:
            matrix[moves[i][0]][moves[i][1]] = 'O'
    for i in range(3):
        if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
            return 'A'
        if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
            return 'B'
        if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X':
            return 'A'
        if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O':
            return 'B'
    if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
        return 'A'
    if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
        return 'A'
    if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
        return 'B'
    if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O':
        return 'B'
    if len(moves) == 9:
        return 'Draw'
    return 'selfending' '''
        self.make_a_matrix = '''
1. make a 3x3 matrix
```
matrix = [[''for _ in range(3)] for _ in range(3)]
```
matrix = {}

2. Main loop one'''
        self.one_interation_fill_the_matrix_X = '''
2.{} one iteration
```
for i in range(len(moves)):
```
i = {}
```
if i % 2 == 0:
```
i % 2 == 0
enter
```
matrix[moves[i][0]][moves[i][1]] = 'X'
```
matrix[moves[i][0]][moves[i][1]] = matrix[{}][{}] = 'X' '''
        self.one_interation_fill_the_matrix_O = '''
2.{} one iteration
```
for i in range(len(moves)):
```
i = {}
```
if i % 2 == 1:
```
i % 2 == 1
not enter
```
else:
    matrix[moves[i][0]][moves[i][1]] = 'O'
```
matrix[moves[i][0]][moves[i][1]] = matrix[{}][{}] = 'O' '''
        self.check_row_A = '''
3.{}.1 check row
```
for i in range(3):
```
i = {}
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
```
matrix[i][0] = '{}'
matrix[i][1] = '{}'
matrix[i][2] = '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X'
enter
```
return 'A'

So the answer is '{}'.'''
        self.check_row_B = '''
3.{} check row
```
for i in range(3):
```
i = {}
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
```
matrix[i][0] = '{}'
matrix[i][1] = '{}'
matrix[i][2] = '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X' is False
not enter
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
```
matrix[i][0] = '{}'
matrix[i][1] = '{}'
matrix[i][2] = '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O'
enter
```
return 'B'

So the answer is '{}'.'''
        self.check_column_A = '''
3.{} check column
```
for i in range(3):
```
i = {}
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X' is False
not enter
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O' is False
not enter
```
if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X':
```
matrix[0][i] = '{}'
matrix[1][i] = '{}'
matrix[2][i] = '{}'
matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X'
enter
```
return 'A'

So the answer is '{}'.'''
        self.check_column_B = '''
3.{} check column
```
for i in range(3):
```
i = {}
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X' is False
not enter
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O' is False
not enter
```
```
if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X':
```
matrix[0][i] = '{}'
matrix[1][i] = '{}'
matrix[2][i] = '{}'
matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X' is False
not enter
```
if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O':
```
matrix[0][i] == '{}'
matrix[1][i] == '{}'
matrix[2][i] == '{}'
matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O'
enter
```
return 'B'

So the answer is '{}'.'''
        self.only_integration = '''
3.{} only integration
```
for i in range(3):
```
i = {}
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X' is False
not enter
```
if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
```
matrix[i][0] == '{}'
matrix[i][1] == '{}'
matrix[i][2] == '{}'
matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O' is False
not enter
```
```
if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X':
```
matrix[0][i] == '{}'
matrix[1][i] == '{}'
matrix[2][i] == '{}'
matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X' is False
not enter
```
if matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O':
```
matrix[0][i] == '{}'
matrix[1][i] == '{}'
matrix[2][i] == '{}'
matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O' is False
not enter'''
        self.check_diagonal_A = '''
4. check diagonal
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X'
enter
```
return 'A'

So the answer is '{}'.'''
        self.check_diagona2_A = '''
4. check diagonal
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X'
enter
```
return 'A'

So the answer is '{}'.'''
        self.check_diagonal_B = '''
4. check diagonal
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X' is False
not enter
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O'
enter
```
return 'B'

So the answer is '{}'.'''
        self.check_diagona2_B = '''
4. check diagonal
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X' if False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X' is False
not enter
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O'
enter
```
return 'B'

So the answer is '{}'.'''
        self.check_draw = '''
4. check draw
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X' is False
not enter
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O' is False
not enter
```
if len(moves) == 9:
```
len(moves) = {}
len(moves) == 9
enter
```
return 'Draw'

So the answer is '{}'.'''
        self.return_result_selfending = '''
4. return result selfending
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X' is False
not enter
```
if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
```
matrix[0][0] = '{}'
matrix[1][1] = '{}'
matrix[2][2] = '{}'
matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O' is False
not enter
```
if matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O':
```
matrix[0][2] = '{}'
matrix[1][1] = '{}'
matrix[2][0] = '{}'
matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O' is False
not enter
```
if len(moves) == 9:
```
len(moves) = {}
len(moves) != 9
not enter
```
return 'selfending'
```
So the answer is '{}'.'''



    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","answer","moves"
        '''
        moves = []
        select = [[0,0],[0,1],[0,2],[1,0],[1,1],[1,2],[2,0],[2,1],[2,2]]
        question = f'''moves = {moves}.A started first. Who's the winner of the Tic Tac Toe Game?'''
        while len(moves) < length:
            move = random.choice(select)
            if move not in moves:
                moves.append(move)
        question = f'''moves = {moves}.A started first. Who's the winner of the Tic Tac Toe Game?'''
        answer = ''
        return {"question": question,
                "answer": answer,
                "moves": moves}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        moves = data["moves"]
        matrix = [[''for _ in range(3)] for _ in range(3)]
        output = self.make_a_matrix.format(matrix)
        for i in range(len(moves)):
            if i % 2 == 0:
                matrix[moves[i][0]][moves[i][1]] = 'X'
                output += self.one_interation_fill_the_matrix_X.format(i+1,i,moves[i][0],moves[i][1])
            else:
                matrix[moves[i][0]][moves[i][1]] = 'O'
                output += self.one_interation_fill_the_matrix_O.format(i+1,i,moves[i][0],moves[i][1])
        for i in range(3):
            if matrix[i][0] == matrix[i][1] == matrix[i][2] == 'X':
                output += self.check_row_A.format(i+1,i,matrix[i][0],matrix[i][1],matrix[i][2],'A')
                answer = "A"
                return {"input": input,
                "output": output,
                "answer": answer}
            elif matrix[i][0] == matrix[i][1] == matrix[i][2] == 'O':
                output += self.check_row_B.format(i+1,i,matrix[i][0],matrix[i][1],matrix[i][2],matrix[i][0],matrix[i][1],matrix[i][2],'B')
                answer = "B"
                return {"input": input,
                "output": output,
                "answer": answer}
            elif matrix[0][i] == matrix[1][i] == matrix[2][i] == 'X':
                output += self.check_column_A.format(i+1,i,matrix[i][0],matrix[i][1],matrix[i][2],matrix[i][0],matrix[i][1],matrix[i][2],matrix[0][i],matrix[1][i],matrix[2][i],'A')
                answer = "A"
                return {"input": input,
                "output": output,
                "answer": answer}
            elif matrix[0][i] == matrix[1][i] == matrix[2][i] == 'O':
                output += self.check_column_B.format(i+1,i,matrix[i][0],matrix[i][1],matrix[i][2],matrix[i][0],matrix[i][1],matrix[i][2],matrix[0][i],matrix[1][i],matrix[2][i],matrix[0][i],matrix[1][i],matrix[2][i],'B')
                answer = "B"
                return {"input": input,
                "output": output,
                "answer": answer}
            else:
                output += self.only_integration.format(i+1,i,matrix[i][0],matrix[i][1],matrix[i][2],matrix[i][0],matrix[i][1],matrix[i][2],matrix[0][i],matrix[1][i],matrix[2][i],matrix[0][i],matrix[1][i],matrix[2][i])  
        if matrix[0][0] == matrix[1][1] == matrix[2][2] == 'X':
            output += self.check_diagonal_A.format(matrix[0][0],matrix[1][1],matrix[2][2],'A')
            answer = "A"
            return {"input": input,
                "output": output,
                "answer": answer}
        elif matrix[0][2] == matrix[1][1] == matrix[2][0] == 'X':
            output += self.check_diagona2_A.format(matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],'A')
            answer = "A"
            return {"input": input,
                "output": output,
                "answer": answer}
        elif matrix[0][0] == matrix[1][1] == matrix[2][2] == 'O':
            output += self.check_diagonal_B.format(matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],matrix[0][0],matrix[1][1],matrix[2][2],'B')
            answer = "B"
            return {"input": input,
                "output": output,
                "answer": answer}
        elif matrix[0][2] == matrix[1][1] == matrix[2][0] == 'O':
            output += self.check_diagona2_B.format(matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],'B')
            answer = "B"
            return {"input": input,
                "output": output,
                "answer": answer}
        elif len(moves) == 9:
            output += self.check_draw.format(matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],len(moves),'Draw')
            answer = "Draw"
            return {"input": input,
                "output": output,
                "answer": answer}
        else:
            output += self.return_result_selfending.format(matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],matrix[0][0],matrix[1][1],matrix[2][2],matrix[0][2],matrix[1][1],matrix[2][0],len(moves),'selfending')
            answer = "selfending"
            return {"input": input,
                "output": output,
                "answer": answer}
        
if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/1275.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))