import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1556  
        self.name = 'https://leetcode.com/problems/thousand-separator/description/'
        self.description = 'Given an integer n, add a dot (".") as the thousands separator and return it in string format.'
        self.url='https://leetcode.com/problems/thousand-separator/description/'
        self.question="Q:Add thousand Separator to the given number\n"
        self.data="The given number is {0}\n"
        self.instruction="Follow the given rule to solve the problem.\nrule:"
        self.rule='''
def thousandSeparator(self, n: int) -> str:
    s = list(str(n))
    r = len(s) - 1
    count = 1
    while r > 0:
        if count == 3:
            s.insert(r,'.')
            r -= 1
            count = 1
        count += 1
        r -= 1
    return ''.join(s)
'''
        self.initialize='''
1.Initialize n,s,r,count
```
n={0}
s={1}
r={2}
count={3}
```
2.Main loops
'''
        self.iteration_2_1_enter='''
2.1 One iteration
```
while r > 0:
```
r={0}
r>0
enter
'''
        self.IF_statement_1_enter='''
IF statement
```
if count == 3:
```
count={0}
count==3
enter
```
s.insert(r,'.')
```
s={1}
```
r -= 1
```
r={2}-1={3}
```
count=1
```
'''
        self.IF_statement_1_do_not_enter='''
IF statement
```
if count == 3:
```
count={0}
count!=3
do not enter
'''
        self.iteration_2_1_enter_inside='''
```
count += 1
```
count={0}+1={1}
```
r -= 1
```
r={2}-1={3}
'''
        self.iteration_2_1_do_not_enter='''
2.1 One iteration
```
while r > 0:
```
r={0}
r==0
do not enter
```
return ''.join(s)
```

So the answer is {1}

'''
    def gen_data_from_len(self, length: int) ->int :
        '''
        return datapoint of given length

        return {...}
        '''
        num=random.randint(1000,1000+10**length)
        return num
    
    def rfft_IO(self, n: int) -> str:
        input=self.question+self.data.format(n)+self.instruction+self.rule
        s = list(str(n))
        r = len(s) - 1
        count = 1
        output=self.question+self.initialize.format(n,s,r,count)
        while r > 0:
            output+=self.iteration_2_1_enter.format(r)
            if count == 3:
                s.insert(r,'.') 
                r -= 1
                count = 1
                output+=self.IF_statement_1_enter.format(count,s,r+1,r)
            else:
                output+=self.IF_statement_1_do_not_enter.format(count)
            count += 1  
            r -= 1
            output+=self.iteration_2_1_enter_inside.format(count,count+1,r+1,r)
        output+=self.iteration_2_1_do_not_enter.format(r,''.join(s))
        return {'input':input,'output':output,'answer':''.join(s)}