import random
import string


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1576  
        self.name = "Replace All ?'s to Avoid Consecutive Repeating Characters"
        self.description ='''Given a string s containing only English letters and the '?' character,.
        Convert all the '?' characters into letters such that the final string does not contain any consecutive repeating characters.'''
        self.url='https://leetcode.com/problems/replace-all-s-to-avoid-consecutive-repeating-characters/description/'
        self.question='''Given a string s containing only lowercase English letters and the '?' character, convert all the '?' characters into lowercase letters such that the final string does not contain any consecutive repeating characters.\n'''
        self.data="The given string is {0}\n"
        self.instruction='''Follow the given rule to solve this problem.\nrule:'''
        self.rule='''
def modifyString(self, s: str) -> str:
    s1 = 'abcdefghijklmnopqrstuvwxyz'
    res = list('0'+s+'0')
    i = 1
    while i < len(res) - 1:
        char = res.pop(i)
        if char == '?':
            prev_char = res[i - 1]
            next_char = res[i]
            available_chars = list(s1)
            while available_chars:
                candidate_char = available_chars.pop(0)
                if candidate_char not in [prev_char, next_char]:
                    res.insert(i, candidate_char)
                    break
        else:
            res.insert(i, char)
        i += 1
    return ''.join(res[1:-1])
'''
        self.initialize='''
1.Initialize s,s1,res,i
```
s={0}
s1='abcdefghijklmnopqrstuvwxyz'
res=['0']+list(s)+['0']
i=1
```
res={1}

2.Main loop
'''
        self.iteration_1_enter='''
2.1 One iteration
```
while i < len(res) - 1:
```
i={0}
len(res)-1={1}-1={3}
{0}<{3}
enter
```
char=res.pop(i)
```
char={2}
res={3}
'''
        self.iteration_1_do_not_enter='''
2.1 One iteration
```
while i < len(res) - 1:
```
i={0}
len(res)-1={1}-1={2}
{0}={2}
do not enter

So the answer is{3}
'''
        self.IF_statement_1_if='''
2.2 IF statement
```
if char == '?':
```
char={0}
enter
```
prev_char=res[i - 1]
next_char=res[i]
available_chars=list(s1)
```
prev_char={1}
next_char={2}
available_chars={3}
'''
        self.IF_statement_1_else='''
2.2 IF statement
```
if char == '?':
```
char={0}
do not enter
```
res.insert(i, char)
```
res={1}
'''
        self.iteration_1_inside='''
```
i+=1
```
i={0}+1={1}
'''
        self.iteration_2_enter='''
2.3 One iteration inside
```
while available_chars:
```
available_chars={0}
True
enter
```
candidate_char=available_chars.pop(0)
```
candidate_char={0}
'''
        self.IF_statement_2_if='''
2.4 IF statement 2
```
if candidate_char not in [prev_char, next_char]:
```
candidate_char={0}
prev_char={1}
next_char={2}
True
enter
```
res.insert(i, candidate_char)
```
res={3}
```
break
```
'''
        self.IF_statement_2_else='''
2.4 IF statement 2
```
if candidate_char not in [prev_char, next_char]:
```
candidate_char={0}
prev_char={1}
next_char={2}
False
do not enter
'''
    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length

        return {...}
        '''
        letters = string.ascii_lowercase
        random_string = ''.join(random.choice(letters) for _ in range(length - 1))
        
        random_index = random.randint(0, length - 1)
        return random_string[:random_index] + '?' + random_string[random_index:]
    def rfft_IO(self, s: str) -> str:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input=self.question+self.data.format(s)+self.instruction+self.rule
        s1 = 'abcdefghijklmnopqrstuvwxyz'
        res = list('0'+s+'0')
        i = 1
        output=self.question+self.initialize.format(s,res)
        while i < len(res) - 1:
            char = res.pop(i)
            output+=self.iteration_1_enter.format(i,len(res)+1,char,len(res),res)
            if char == '?':
                prev_char = res[i - 1]
                next_char = res[i]
                available_chars = list(s1)
                output+=self.IF_statement_1_if.format(char,prev_char,next_char,available_chars)
                while available_chars:
                    candidate_char = available_chars.pop(0)
                    output+=self.iteration_2_enter.format(available_chars)
                    if candidate_char not in [prev_char, next_char]:
                        res.insert(i, candidate_char)
                        output+=self.IF_statement_2_if.format(candidate_char,prev_char,next_char,res)
                        break
            else:
                res.insert(i, char)
                output+=self.IF_statement_1_else.format(char,res)
            i += 1
            output+=self.iteration_1_inside.format(i-1,i)
        output+=self.iteration_1_do_not_enter.format(i,len(res),len(res)-1,''.join(res[1:-1]))

        return {'input':input,'output':output,'answer':''.join(res[1:-1])}
    
