from collections import deque
import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1823  
        self.name = 'Find the Winner of the Circular Game'
        self.description = '''Try to find the winner of the circular game.Rule: The kth person next to the start person will be kicked off the game.Find the last person left in the game.'''

        self.url='https://leetcode.com/problems/find-the-winner-of-the-circular-game/'
        self.question='''Q:In a game, there are n people sitting in a circle .Game starts from the first person.
        The kth person next to him wil be removed from the game and the game will start again from bext people until there's only one remain.
        Try to find out who wil be the last person\n'''
        self.instruction="Follow the given rule to solve this problem.\nrule:\n"
        self.data="The given number is {0} and the number of steps is {1}.\n"
        self.rule='''
def findTheWinner(self, n: int, k: int) -> int:
    q = deque(range(1, n + 1))
    while len(q) > 1:
        for _ in range(k - 1):
            q.append(q.popleft())
        q.popleft()
    return q[0]   
'''
        self.initialize='''
1.Initialize n,k,q
```
n={0}
k={1}
q={2}
```
2.Main loop'''
        self.iteration_2_1_enter='''
2.1 One iteration
```
while len(q) > 1:
```
q={1}
len(q)={0}
{0}>1
enter'''
        self.for_iteration_2_1_1_step1='''
```
for _ in range(k - 1):
```
range(k-1)={2}
_={0}
```
x=q.popleft()
```
q={1}'''
        self.for_iteration_2_1_1_step2='''
x={0}
```
q.append(x)
```
q={1}
'''
        self.q_pop_left='''
```
q.popleft()
```
q={0}
'''
        self.iteration_2_1_do_not_enter='''
while len(q)>1:
```
len(q)=1
do not enter


So the answer is {}
'''
    def gen_data_from_len(self,length):
        n=length
        k=random.randint(0,n)
        return (n, k)
    def rfft_IO(self, ttmp) -> int:
        n, k = ttmp
        q = deque(range(1, n + 1))
        input=self.question+self.instruction+self.data.format(n,k)+self.rule
        output=self.question+self.data+self.initialize.format(n,k,q)

        while len(q) > 1:
            output+=self.iteration_2_1_enter.format(len(q),q)
            for _ in range(k - 1):
                output+=self.for_iteration_2_1_1_step1.format(_,q,[e for e in range(k-1)])
                x=q.popleft()
                q.append(x)
                output+=self.for_iteration_2_1_1_step2.format(x,q)
            q.popleft()
            output+=self.q_pop_left.format(q)
        output+=self.iteration_2_1_do_not_enter.format(q[0])
        return {'input':input,'output':output,'answer':q[0]}