import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1909
        self.name = "canBeIncreasing"
        self.description = '''Given an array nums. Can we remove one element to make it increasing?'''
        self.url = '''https://leetcode.com/problems/remove-one-element-to-make-the-array-strictly-increasing/description/'''
        self.rule = '''
def canBeIncreasing(self, nums: List[int]) -> bool:
    n = len(nums)
    i = 0
    def check(index):
        temp = nums[:index] + nums[index+1:]
        j = 1
        while j < len(temp):
            if temp[j] <= temp[j-1]:
                return False
            j += 1
        return True
    while i < n:
        if check(i):
            return True
        i += 1
    return False'''
        self.initialize = '''
1. initialize
```
n = len(nums)
```
n = {}
```
i = 0
```

2. Main loop'''
        self.one_interation = '''
2.{} one iteration
```
while i < n:
```
i = {}
n = {}
i < n
enter
```
if check(i):
```
```
def check(index):
```
index = i = {}
```
temp = nums[:index] + nums[index+1:]
```
temp = {}
```
j = 1
```'''
        self.not_enter_loop1 = '''
2.{} one iteration
```
while i < n:
```
i = {}
n = {}
i >= n
not enter'''
        self.check_one_iteration_in = '''
2.{}.{} one iteration
```
while j < len(temp):
```
j = {}
len(temp) = {}
j < len(temp)
enter
```
if temp[j] <= temp[j-1]:
```
temp[j] = {}
temp[j-1] = {}
temp[j] <= temp[j-1]
enter
```
return False
```
check(index) = check({}) == False
not enter if check(i)
```
i += 1
```
i = {}'''
        self.check_one_iteration_not_in = '''
2.{}.{} one iteration
```
while j < len(temp):
```
j = {}
len(temp) = {}
j < len(temp)
enter
```
if temp[j] <= temp[j-1]:
```
temp[j] = {}
temp[j-1] = {}
temp[j] > temp[j-1]
not enter
```
j += 1
```
j = {}'''
        self.not_enter_loop2 = '''
2.{}.{} one iteration
```
while j < len(temp):
```
j = {}
len(temp) = {}
j >= len(temp)
not enter'''
        self.check_one_iteration_out = '''
```
return True
```
check(index) = check({}) == True
enter
```
return True
```
So the answer is True.'''
        self.end = '''
3. end
```
return False
```
So the answer is False.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","nums"
        '''
        nums = [random.choice(range(1,20)) for _ in range(length)]
        question = f'''nums = {nums}. Can we remove one element to make it increasing?'''
        return {"question": question,
                "nums": nums}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qustion = data["question"]
        input = instruction + rule + "\n\nQ: " + qustion
        nums = data["nums"]
        n = len(nums)
        output = []
        output.append(self.initialize.format(n))
        answer = False
        def check(index):
            temp = nums[:index] + nums[index+1:]
            output.append(self.one_interation.format(index+1,index,n,index,temp))
            j = 1
            while j < len(temp):
                if temp[j] <= temp[j-1]:
                    output.append(self.check_one_iteration_in.format(index+1,j,j,len(temp),temp[j],temp[j-1],index,index+1))
                    return False
                else:
                    output.append(self.check_one_iteration_not_in.format(index+1,j,j,len(temp),temp[j],temp[j-1],j+1))
                j += 1
            if j >= len(temp):
                output.append(self.not_enter_loop2.format(index+1,j,j,len(temp)))
            output.append(self.check_one_iteration_out.format(index))
            return True
        i = 0
        while i < n:
            if check(i):
                answer = True
                break
            i += 1
        if i >= n:
            output.append(self.not_enter_loop1.format(i,n,n))
        if not answer:
            output.append(self.end)
        output = "".join(output)
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/1909.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))