import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2016
        self.name = "maximumDifference"
        self.description = '''Given a 0-indexed integer array nums of size n. What is the difference between the smallest and the largest number?'''
        self.url = '''https://leetcode.com/problems/maximum-difference-between-increasing-elements/description/'''
        self.rule = '''
def maximumDifference(nums: list[int]) -> int:
    min_ = 10**9
    max_ = 0
    while nums:
        num = nums.pop(0)
        min_ = min(min_, num)
        max_ = max(max_, num - min_)
    if max_ > 0:
        return max_
    else:
        return -1'''
        self.initialize = '''
1. Initialize
```
min_ = 10**9
```
```
max_ = 0
```
2. Main loop'''
        self.one_interation = '''
2.{} one iteration
```
while nums:
```
nums = {}
enter
```
num = nums.pop(0)
```
num = {}
```
min_ = min(min_, num)
```
min_ = min({},{}) = {}
```
max_ = max(max_, num - min_)
```
max_ = max({},{}) = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while nums:
```
nums = {}
not enter'''
        self.return_result_True = '''
3. Return result
```
if max_ > 0:
```
max_ = {}
max_ > 0
enter
```
return max_
```
So the answer is {}.'''
        self.return_result_False = '''
3. Return result
```
if max_ > 0:
```
max_ = {}
max_ <= 0
not enter
```
return -1
```
So the answer is -1.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","nums"
        '''
        nums = [random.choice(range(1,100)) for _ in range(length)]
        question = f'''nums = {nums}. What is the difference between the smallest and the largest number?'''
        return {"question": question,
                "nums": nums}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        nums = data["nums"]
        min_ = 10**9
        max_ = 0
        output = self.initialize
        i = 1
        while nums:
            nums_copy = deepcopy(nums)
            num = nums.pop(0)
            min1 = min_
            max1 = max_
            min_ = min(min_, num)
            max_ = max(max_, num - min_)
            output += self.one_interation.format(i,nums_copy,num,min1,num,min_,max1,num-min_,max_)
            i += 1
        if not nums:
            output += self.not_enter_loop.format(i,nums)
        if max_ > 0:
            output += self.return_result_True.format(max_,max_)
            answer = max_

        else:
            output += self.return_result_False.format(max_)
            answer = -1
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2016.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))