import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2057
        self.name = "smallestEqual"
        self.description = '''Given a 0-indexed integer array nums, What's the smallest index i of nums such that i mod 10 == nums[i]?'''
        self.url = '''https://leetcode.com/problems/smallest-index-with-equal-value/'''
        self.rule = '''
def smallestEqual(self, nums: list[int]) -> int:
    i = 0
    result = -1
    while nums:
        num = nums.pop(0)
        if i % 10 == num:
            result = i
            break
        i += 1
    return result'''
        self.initialize = '''
1. Initialize
```
i = 0
```
```
result = -1
```

2. Main loop'''
        self.one_interation_in = '''
2.{} one iteration
```
while nums:
```
nums = {}
enter
```
num = nums.pop(0)
```
num = {}
```
if i % 10 == num: 
```
i = {}
i % 10 == num
enter
```
result = i
```
result = {}
```
break
```'''
        self.one_interation_not_in = '''
2.{} one iteration
```
while nums:
```
nums = {}
enter
```
num = nums.pop(0)
```
num = {}
```
if i % 10 == num:
```
i = {}
i % 10 != num
not enter
```
i += 1
```
i = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while nums:
```
nums = {}
not enter'''
        self.return_result = '''
3. Return result
```
return result
```
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","nums"
        '''
        nums = [random.choice(range(1,10)) for _ in range(length)]
        question = f'''nums = {nums}. What's the maximum difference?'''
        return {"question": question,
                "nums": nums}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        nums = data["nums"]
        i = 0
        result = -1
        output = self.initialize
        while nums:
            nums_copy = deepcopy(nums)
            num = nums.pop(0)
            if i % 10 == num:
                result = i
                output += self.one_interation_in.format(i+1,nums_copy,num,i,result)
                break
            else:
                output += self.one_interation_not_in.format(i+1,nums_copy,num,i,i+1)
            i += 1
        if not nums:
            output += self.not_enter_loop.format(i,nums)
        output += self.return_result.format(result)
        answer = result
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2057.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))