import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2078
        self.name = "maxDistance"
        self.description = '''You are given a 0-indexed integer array colors of length n. What's the maximum different colors?'''
        self.url = '''https://leetcode.com/problems/two-furthest-houses-with-different-colors/description/'''
        self.rule = '''
def maxDistance(self, colors: list[int]) -> int:
    first = colors[0]
    end = colors[-1]
    max_ = 0
    n = len(colors)
    i = 0
    while colors:
        color = colors.pop(0)
        if first != color:
            max_ = max(max_,i)
        if end != color:
            max_ = max(max_,n-i-1)
        i += 1
    return max_'''
        self.initialize = '''
1. Initialize
```
first = colors[0]
```
first = {}
```
end = colors[-1]
```
end = {}
```
max_ = 0
```
```
n = len(colors)
```
n = {}
```
i = 0
```

2. Main loop'''
        self.interation_judge_one_in = '''
2.{} one interation
```
while colors:
```
colors = {}
enter
```
color = colors.pop(0)
```
color = {}
```
if first != color:
```
color = {}
first != color
enter
```
max_ = max(max_,i)
```
max_ = max({},{}) = {}'''
        self.interation_judge_one_not_in = '''
2.{} one interation
```
while colors:
```
colors = {}
enter
```
color = colors.pop(0)
```
color = {}
```
if first != color:
```
color = {}
first == color
not enter'''
        self.interation_judge_two_in = '''
```
if end != color:
```
color = {}
end != color
enter
```
max_ = max(max_,n-i-1)
```
max_ = max({},{}) = {}
```
i += 1
```
i = {}'''
        self.interation_judge_two_not_in = '''
```
if end != color:
```
color = {}
end == color
not enter
```
i += 1
```
i = {}'''
        self.not_enter_loop = '''
2.{} one interation
```
while colors:
```
colors = {}
not enter'''
        self.reture_result = '''
3. Return result
```
return max_
```
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","colors"
        '''
        colors = [random.choice(range(1,10)) for _ in range(length)]
        question = f'''colors = {colors}. What's the maximum difference?'''
        return {"question": question,
                "colors":colors}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        colors = data["colors"]
        first = colors[0]
        end = colors[-1]
        max_ = 0
        n = len(colors)
        i = 0
        output = self.initialize.format(first,end,n)
        while colors:
            colors_copy = deepcopy(colors)
            color = colors.pop(0)
            if first != color:
                max1 = max_
                max_ = max(max_,i)
                output += self.interation_judge_one_in.format(i+1,colors_copy,color,color,max1,i,max_)
            else:
                output += self.interation_judge_one_not_in.format(i+1,colors_copy,color,color)
            if end != color:
                max2 = max_
                max_ = max(max_,n-i-1)
                output += self.interation_judge_two_in.format(color,max2,n-i-1,max_,i+1)
            else:
                output += self.interation_judge_two_not_in.format(color,i+1)
            i += 1
        if not colors:
            output += self.not_enter_loop.format(i,colors)
        output += self.reture_result.format(max_)
        answer = max_
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2078.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))