import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2103
        self.name = "countselfoints"
        self.description = '''Given a string rings of length 2n that describes the n rings that are placed onto the rods. Every two characters in rings forms a color-position pair that is used to describe each ring. How many are the number of rods that have all three colors of rings on them?'''
        self.url = '''https://leetcode.com/problems/rings-and-rods/description/'''
        self.rule = '''
def countselfoints(self, rings: str) -> int:
    rings = list(rings)
    colors = rings[::2]
    nums = rings[1::2]
    sum = 0
    list1 = [[] for _ in range(10)]
    while colors and nums:
        color = colors.pop(0)
        num = nums.pop(0)
        if color not in list1[int(num)]:
            list1[int(num)].append(color)
            if set(list1[int(num)]) == set(['B', 'R', 'G']):
                sum += 1
    return sum'''
        self.initialize = '''
1. Initialize
```
rings = list(rings)
```
rings = {}
```
colors = rings[::2]
```
colors = {}
```
nums = rings[1::2]
```
nums = {}
```
sum = 0
```
```
list1 = [[] for _ in range(10)]
```
list1 = {}

2. Main loop'''
        self.interation_judge_one_in = '''
2.{} one interation
```
while colors and nums:
```
colors = {}
nums = {}
enter
```
color = colors.pop(0)
```
color = '{}'
```
num = nums.pop(0)
```
num = '{}'
```
if color not in list1[int(num)]:
```
color = '{}'
list1[int(num)] = {}
color not in list1[int(num)]
enter'''
        self.interation_judge_one_in_in = '''
```
list1[int(num)].append(color)
```
list1[int(num)] = {}
```
if set(list1[int(num)]) == set(['B', 'R', 'G']):
```
set(list1[int(num)]) = {}
set(list1[int(num)]) == set(['B', 'R', 'G'])
enter
```
sum += 1
```
sum = {}'''
        self.interation_judge_one_not_in = '''
2.{} one interation
```
while colors and nums:
```
colors = {}
nums = {}
enter
```
color = colors.pop(0)
```
color = '{}'
```
num = nums.pop(0)
```
num = '{}'
```
if color not in list1[int(num)]:
```
color = '{}'
list1[int(num)] = {}
color in list1[int(num)]
not enter'''
        self.interation_judge_one_in_not_in = '''
```
list1[int(num)].append(color)
```
list1[int(num)] = {}
```
if set(list1[int(num)]) == set(['B', 'R', 'G']):
```
set(list1[int(num)]) = {}
set(list1[int(num)]) != set(['B', 'R', 'G'])
not enter'''
        self.not_enter_loop = '''
2.{} one interation
```
while colors and nums:
```
colors = {}
nums = {}
not enter'''
        self.return_result = '''
3. Return resilt
```
return sum
```
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","rings"
        '''
        rings = ''.join([random.choice(["B","R","G"]) + str(random.choice(range(10))) for _ in range(length)])
        question = f'''rings = "{rings}". How many are the number of rods that have all three colors of rings on them.'''
        return {"question": question,
                "rings": rings}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        rings = data["rings"]
        rings = list(rings)
        colors = rings[::2]
        nums = rings[1::2]
        sum = 0
        list1 = [[] for _ in range(10)]
        i = 1
        output = self.initialize.format(rings,colors,nums,list1)
        while colors and nums:
            colors_copy = deepcopy(colors)
            nums_copy = deepcopy(nums)
            color = colors.pop(0)
            num = nums.pop(0)
            if color not in list1[int(num)]:
                list1[int(num)].append(color)
                output += self.interation_judge_one_in.format(i,colors_copy,nums_copy,color,num,color,list1[int(num)])
                if set(list1[int(num)]) == set(['B', 'R', 'G']):
                    sum += 1
                    output += self.interation_judge_one_in_in.format(list1[int(num)],set(list1[int(num)]),sum)
                else:
                    output += self.interation_judge_one_in_not_in.format(list1[int(num)],set(list1[int(num)]))
            else:
                output += self.interation_judge_one_not_in.format(i,colors_copy,nums_copy,color,num,color,list1[int(num)])
            i += 1
        if not colors and not nums:
            output += self.not_enter_loop.format(i,colors,nums)
        output += self.return_result.format(sum)
        answer = sum
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2103.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))