import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2129
        self.name = "capitalizeTitle"
        self.description = '''If the length of the word is 1 or 2 letters, change all letters to lowercase. If the length of the word is 3 or more letters, change the first letter to uppercase and the rest to lowercase. What is the title after capitalizing it?'''
        self.url = '''https://leetcode.com/problems/capitalize-the-title/description/'''
        self.rule = '''
def capitalizeTitle(title: str) -> str:
    title_lower = title.lower()
    title_list = title_lower.split()
    result_list = []
    while title_list:
        word = title_list.pop(0)
        if len(word) < 3:
            result_list.append(word)
        else:
            word_list = list(word)
            word_result = ''.join([word_list[0].upper()] + word_list[1:])
            result_list.append(word_result)
    result = ' '.join(result_list)
    return result'''
        self.initialize = '''
1. Initialize
```
title_lower = title.lower()
```
title_lower = '{}'
```
title_list = title_lower.split()
```
title_list = {}
```
result_list = []
```

2. Main loop'''
        self.interation_in = '''
2.{} one iteration
```
while title_list:
```
title_list = {}
enter
```
word = title_list.pop(0)
```
word = '{}'
```
if len(word) < 3:
```
len(word) = {} < 3
enter
```
result_list.append(word)
```
result_list = {}'''
        self.interation_not_in = '''
2.{} one iteration
```
while title_list:
```
title_list = {}
enter
```
word = title_list.pop(0)
```
word = '{}'
```
if len(word) < 3:
```
len(word) = {} >= 3
not enter
```
else:
```
word_list = list(word)
```
word_list = {}
```
word_result = ''.join([word_list[0].upper()] + word_list[1:])
```
word_result = '{}'
```
result_list.append(word_result)
```
result_list = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while title_list:
```
title_list = {}
not enter'''
        self.return_result = '''
3. Return result
```
result = ' '.join(result_list)
```
result = '{}'
```
return result
```
So the answer is '{}'.'''
    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","title"
        '''
        import string
        title = ' '.join([''.join(random.choices(string.ascii_lowercase + string.ascii_uppercase, k=random.choice(range(1,10)))) for _ in range(length)])
        question = f'''title = "{title}". If the length of the word is 1 or 2 letters, change all letters to lowercase. If the length of the word is 3 or more letters, change the first letter to uppercase and the rest to lowercase. What is the title after capitalizing it?'''
        return {"question": question,
                "title": title}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        title = data["title"]
        title_lower = title.lower()
        title_list = title_lower.split()
        result_list = []
        output = self.initialize.format(title_lower,title_list)
        i = 1
        while title_list:
            title_list_copy = deepcopy(title_list)
            word = title_list.pop(0)
            if len(word) < 3:
                result_list.append(word)
                output += self.interation_in.format(i,title_list_copy,word,len(word),result_list)
            else:
                word_list = list(word)
                word_result = ''.join([word_list[0].upper()] + word_list[1:])
                result_list.append(word_result)
                output += self.interation_not_in.format(i,title_list_copy,word,len(word),word_list,word_result,result_list)
            i += 1
        if not title_list:
            output += self.not_enter_loop.format(i,title_list)
        result = ' '.join(result_list)
        answer = result
        output += self.return_result.format(result,result)
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2129.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))
        
