import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2185  
        self.name = 'Counting Words With a Given Prefix'
        self.description = 'Return the words that starts with given pref'
        self.url='https://leetcode.com/problems/counting-words-with-a-given-prefix/description/'
        self.question="Q:Find how many words is start with pref\n"
        self.data="words={0},pref={1}\n"
        self.instruction="Follow the given rules to solve the problem\nrule:"
        self.rule='''
def prefixCount(self, words: List[str], pref: str) -> int:
    time=0
    iteration_time=0
    lenth=len(words)
    while iteration_time<lenth:
        word=words.pop(0)
        if word.startswith(pref):
            time+=1
        iteration_time+=1
    return time
'''
        self.initialize='''
1.Initialize time,iteration_time,lenth
```
time=0
iteration_time=0
lenth={0}
```
2.Main loops'''
        self.iteration_2_1_enter='''
2.1 One iteration
```
while iteration_time<lenth:
```
iteration_time={0}
lenth={1}
iteration_time<lenth
enter
```
word=words.pop(0)
```
word={2}
'''
        self.iteration_2_1__do_not_enter='''
2.1 One iteration
```
while iteration_time<lenth:
```
iteration_time={0}
lenth={1}
iteration_time=lenth
do not enter

So the answer is {2}

'''
        self.iteration_time_plus='''
```
iteration_time+=1
```
iteration_time={1}+1={0}
'''
        self.IF_statement_enter='''
If_statement
```
if word.startswith(pref):
```
word={0}
pref={1}
True
enter
```
time+=1
```
time={3}+1={2}
'''
        self.IF_statement_do_not_enter='''
If_statement
```
if word.startswith(pref):
```
word={0}
pref={1}
False
do not enter
'''
    def gen_data_from_len(self,length)->list:
        '''
        return datapoint of given length
        '''
        pref=random.choice([chr(i) for i in range(ord('a'),ord('z')+1)])+random.choice([chr(i) for i in range(ord('a'),ord('z')+1)])
        words=[]
        for i in range(length):
            sign=random.choice([True,False])
            if sign:
                for i in range(random.randint(1,5)):
                    words.append(pref+random.choice([chr(i) for i in range(ord('a'),ord('z')+1)]))
            else:
                for i in range(random.randint(1,7)):

                    words.append(random.choice([chr(i) for i in range(ord('a'),ord('z')+1)]))
        return (words,pref)
    
    def rfft_IO(self, ttmp) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        words,pref=ttmp
        input=self.question+self.data.format(words,pref)+self.instruction+self.rule
        output=self.question
        time=0
        iteration_time=0
        lenth=len(words)
        output+=self.initialize.format(lenth)
        while iteration_time<lenth:
            word=words.pop(0)
            output+=self.iteration_2_1_enter.format(iteration_time,lenth,word)
            if word.startswith(pref):
                time+=1
                output+=self.IF_statement_enter.format(word,pref,time,time-1)
            output+=self.IF_statement_do_not_enter.format(word,pref)
            iteration_time+=1
            output+=self.iteration_time_plus.format(iteration_time,iteration_time-1,time)
        output+=self.iteration_2_1__do_not_enter.format(iteration_time,lenth,time)
        return {'input':input,
                'output':output,
                'answer':time}




        