import numpy as np
import random
from typing import List
class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 228
        self.name='Summary Ranges'
        self.description='Give a sorted unique integer array, return the smallest sorted list of ranges that cover all the numbers in the array exactly,and no extra integer being covered'
        self.url='https://leetcode.com/problems/summary-ranges/description/'
        self.data="The given list is {}\n "
        self.question='Give a sorted unique integer array, return the smallest sorted list of ranges that cover all the numbers in the array exactly,and no extra integer being covered\n'
        self.instruction="Follow the given rule to solve the question.\nrule: "
        self.rule='''
def summary_ranges(self, nums: List[int]) -> List[str]:
        storage = []
        iteration_time=0
        while iteration_time<len(nums):
            i=nums.pop(iteration_time)
            nums.insert(iteration_time,i)
            iteration_time+=1
            if i-1 not in nums:
                left = i
                gap = 1
                while left + gap in nums:  # find consecutive range
                    gap += 1
                if gap > 1:
                    storage.append(str(i)+'->'+str(left + gap - 1))  #consecutive
                else:
                    storage.append(str(i))  # only itself  
            else:
                pass         
        return storage'''
        self.initialize='''
1.Initialize storage,length,iteration_time,nums,left,gap
```
storage = []
iteration_time=0
nums={}
left=0
gap=0
```
2.Main loops'''
        self.iteration_2_1_enter='''
2.1 one iteration
```
while iteration_time<len(nums):
```
iteration_time={2} < len(nums)={3}
enter
```
i=nums.pop(iteration_time)
```
i={0}
```
nums.insert(iteration_time,i)
```
nums={1}
```
iteration_time+=1
```
iteration_time={2}'''   
        self.iteration_2_1_do_not_enter='''
2.1 one iteration
```
while iteration_time<len(nums):
```
iteration_time={0} = len(nums)={1}
do not enter'''
        self.IF_statement_1_enter='''
IF_statement_1
```
if i-1 not in nums:
```
i-1= {0} not in nums={1}
enter
```
left = i
```
left = {2}
```
gap = 1
```
gap = {3}
'''
        self.IF_statement_1_do_not_enter='''
IF_statement_1
```
if i-1 not in nums:
```
i-1= {0} in nums={1}
do not enter
'''
        self.iteration_2_2_enter='''
2.2 one iteration
```
while left + gap in nums:
```
left + gap = {0} in nums={1}
enter
```
gap += 1
```
gap = {2}
'''
        self.iteration_2_2__do_not_enter='''
2.2 one iteration
```
while left + gap in nums:
```
left + gap = {0} not in nums={1}
do not enter
```
'''
        self.IF_statement_1_1_enter='''
IF_statement_1_1
```
if gap > 1:
```
gap= {0} >1
enter
```
storage.append(str(i)+'->'+str(left + gap - 1))
```
storage={1}
'''
        self.IF_statement_1_1_do_not_enter='''
IF_statement_1_1
```
if gap > 1:
```
gap= {0} <= 1
do not enter
```
else:
        storage.append(str(i))
```
storage={1}

So the final answer is {1}
'''
    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length
        '''
        n=1
        nums=[]
        while n<length:
            c=random.randint(1,20)
            if c not in nums:
                nums.append(c)
            n+=1
        nums.sort()
        return nums
    def rfft_IO(self, nums: List[int]) -> List[str]:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input=self.question+self.data.format(nums)+self.instruction+self.rule
        output=self.question+self.initialize.format(nums)
        storage = []
        iteration_time=0
        while iteration_time<len(nums):
            i=nums.pop(iteration_time)
            nums.insert(iteration_time,i)
            iteration_time+=1
            output+=self.iteration_2_1_enter.format(i,nums,iteration_time,len(nums))
            if i-1 not in nums:
                left = i
                gap = 1
                output+=self.IF_statement_1_enter.format(i-1,nums,left,gap)
                while left + gap in nums:  # find consecutive range
                    output+=self.iteration_2_2_enter.format(left+gap,nums,gap+1)
                    gap += 1
                output+=self.iteration_2_2__do_not_enter.format(left+gap,nums)
                if gap > 1:
                    storage.append(str(i)+'->'+str(left + gap - 1))  #consecutive
                    output+=self.IF_statement_1_1_enter.format(gap,storage)
                else:
                    storage.append(str(i))  # only itself
                    output+=self.IF_statement_1_1_do_not_enter.format(gap,storage)
            else:
                output+=self.IF_statement_1_do_not_enter.format(i-1,nums)
                pass
        output+=self.iteration_2_1_do_not_enter.format(iteration_time,len(nums))  
        ans=storage
        return {"input":input,
                "output":output,
                "answer":ans}


                


