import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2390
        self.name = 'removeStars'
        self.description = '''Given a string s containing lowercase English letters and '*', return the string obtained by removing all '*' and the character that comes before '*'.'''
        self.url = 'https://leetcode.com/problems/removing-stars-from-a-string/'

        self.rule = '''
def removeStars(self, s: str) -> str:
    ans = [''] * len(s)
    s = list(s)
    while s:
        a = s.pop(0)
        if a == '*':
            ans.pop()
        else:
            ans.append(a)
    return ''.join(ans)
'''
        self.initialize = '''
1. Initialize
```
ans = [''] * len(s)
```
```
s = list(s)
```
s = {}
```
2. Main loop'''
        self.initialize_in = '''
2.{} one interation
```
while s:
```
s = {}
enter
```
a = s.pop(0)
```
a = '{}'
```
if a == '*':
```
a == '*'
enter
```
ans.pop()
```
ans = {}'''
        self.initialize_not_in = '''
2.{} one interation
```
while s:
```
s = {}
enter
```
a = s.pop(0)
```
a = '{}'
```
if a == '*':
```
a = '{}'
a != '*'
not enter
```
else:
    ans.append(a)
```
ans = {}'''
        self.not_enter_loop = '''
2.{} one interation
```
while s:
```
s = {}
not enter'''
        self.return_result = '''
3. Return result
```
return ''.join(ans)
```
return '{}'
```
So the answer is '{}'.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        import string
        s = ''.join(random.choices(string.ascii_lowercase + '**************', k=length))
        question = f'''s = "{s}". Given a string s containing lowercase English letters and '*', return the string obtained by removing all '*' and the character that comes before '*'.'''
        return {"question": question,
                "s": s}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        s = data["s"]
        ans = ['']*len(s)
        s = list(s)
        output = self.initialize.format(s)
        i = 1
        while s:
            s_ = s.copy()
            a = s.pop(0)
            if a == '*':
                ans.pop()
                output += self.initialize_in.format(i,s_,a,ans)
            else:
                ans.append(a)
                output += self.initialize_not_in.format(i,s_,a,a,ans)
            i += 1
        if not s:
            output += self.not_enter_loop.format(i,s)
        answer = ''.join(ans)
        output += self.return_result.format(answer,answer)
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2390.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))