import random
from typing import List
class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2529 
        self.name = 'maximum count of positive integer and negative integer' 
        self.description = "Given an array nums sorted in non-decreasing order, find the maximum between the number of positive integers and the number of negative integers."
        self.url='https://leetcode.com/problems/maximum-count-of-positive-integer-and-negative-integer/description/'
        self.question="Q:Give an array nums, return the maximum between the number of positive integers and the number of negative integers.\n"
        self.data="The given array nums is {}"
        self.instruction= "Follow the given rule to solve the question.\nrule: "
        self.rule='''
    def maximumCount(self, nums: List[int]) -> int:
        pos=0
        neg=0
        while nums:
            num=nums.pop(0)
            if num>0:
                pos+=1
            elif num<0:
                neg+=1
            else:
                pass
        if pos>=neg:
            return pos
        else:
            return neg   
'''
        self.initialize='''
1.Initialize nums,pos,neg
```
nums={0}
pos=0
neg=0
```
2.Main loops'''
        self.iteration_2_1_enter='''
2.1 One iteration
```
while nums:
```
True
enter
```
num=nums.pop(0)
```
num={0}
'''
        self.iteration_2_1_do_not_enter='''
2.1 One iteration
```
while nums:
```
False
do not enter
'''
        self.IF_statement_1_if='''
IF statement 1
```
if num>0:
```
num={0} > 0
enter
```
pos+=1
```
pos={2}+1={1}
'''
        self.IF_statement_1_elif='''
IF statement 1
```
if num>0:
```
num={0} < 0
do not enter
```
elif num<0:
```
num={0} < 0
enter
```
neg+=1
```
neg={2}+1={1}
'''
        self.IF_statement_1_else='''
IF statement 1
```
if num>0:
```
num={0}
do not enter
```
elif num<0:
```
num={0}
do not enter
```
else:
    pass
```
'''
        self.IF_statement_2_if='''
IF statement 2
```
if pos>=neg:
```
pos={0}
neg={1}
pos>=neg
enter

So the answer is {0}
'''
        self.IF_statement_2_ELES='''
IF statement 2
```
if pos>=neg:
```
pos={0}
neg={1}
pos<neg
do not enter
```

So the answer is {1}
'''
    def gen_data_from_len(self,length):
        '''
        return datapoint of given length
        '''
        array = [random.randint(-100, 100) for _ in range(length)]
        return sorted(array)
    def rfft_IO(self, nums: List[int]) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input=self.question+self.data.format(nums)+self.instruction+self.rule
        output=self.question+self.initialize.format(nums)
        pos=0
        neg=0
        while nums:
            num=nums.pop(0)
            output+=self.iteration_2_1_enter.format(num)
            if num>0:
                pos+=1
                output+=self.IF_statement_1_if.format(num,pos,pos-1)
            elif num<0:
                neg+=1
                output+=self.IF_statement_1_elif.format(num,neg,neg-1)
            else:
                output+=self.IF_statement_1_else.format(num)
                pass
        output+=self.iteration_2_1_do_not_enter
        if pos>=neg:
            output+=self.IF_statement_2_if.format(pos,neg)
            return {"input":input,
                    "output":output,
                    "answer":pos}
        else:
            output+=self.IF_statement_2_ELES.format(pos,neg)
            return {"input":input,
                    "output":output,
                    "answer":neg}
