
import numpy as np
import random
from prompt import Prompt
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2562  
        self.name =  'array_concatenation_value'  
        self.description = "concatenate the array into a string and calculate the value"  
        self.url = "https://leetcode.com/problems/find-the-array-concatenation-value/description/"
         
        self.rule = '''
def arrayConcatenationValue(nums):
# Initialize variables
n = len(nums)
res = 0
i = 0
# Main loop
while i < int(n/2):
    cnt = len(str(nums[n-i-1]))
    res = res+nums[i]*(10**cnt)
    res = res+nums[n-i-1]
    i += 1
# Judge
if n%2!=0:
    res =res+nums[int(n/2)]
# Return
return res'''
        self.initialize = '''
1. Initialize variables
```
n = len(nums)
res = 0
i = 0
```
nums = {}
n = len(nums) = {}
2. Main loop'''
        self.one_iteration_2_1 = '''
2.1 one iteration
```
for i in range(0,int(n/2)):
```
i = {} < int(n/2) = int({}/2) = {}
enter
```
cnt = len(str(nums[n-i-1]))
```
nums = {}
nums[n-i-1] = nums[{}-{}-1] = nums[{}] = {}
cnt = len(str(nums[n-i-1])) = len(str({})) = {}
```
res = res+nums[i]*(10**cnt)
```
nums = {}
res = res+nums[{}]*(10**cnt) = {}+{}*(10**{}) = {}'''
        self.one_iteration_2_1_2 = '''
```
res = res+nums[n-i-1]
```
nums = {}
res = res+nums[n-i-1] = res+nums[{}-{}-1] = {}+nums[{}] = {}+{} = {}
```
i += 1
```
i = i + 1 = {} + 1 = {}'''
        self.complete_loop = '''
2.1 one iteration
```
for i in range(0,int(n/2)):
```
i = {} >= int(n/2) = int({}/2) = {}
do not enter
3. Judge'''
        self.judge_1 = '''
```
if n%2!=0:
```
n%2 = {}%2 = {} != 0
enter
```
res =res+nums[int(n/2)]
```
res =res+nums[int({}/2] = res+nums[{}] = {}+{} = {}'''
        self.judge_2 = '''
```
if n%2!=0:
```
n%2 = {}%2 = {} == 0
do not enter'''
        self.return_result = '''
4. Return
```
return res
```
res = {}
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        nums = random.choices(range(1, 100), k=length)
        question = f"An array nums is {nums}, select the first and last elements in nums, concatenate their values, add this concatenated value to the concatenated sum of nums, and then remove the first and last elements from nums.If there is only one element, add the value of that element to the concatenated sum of nums, and then remove this element."
        n = len(nums)
        res = 0
        for i in range(0,int(n/2)):
            cnt = len(str(nums[n-i-1]))
            res = res+nums[i]*(10**cnt)
            res = res+nums[n-i-1]
        if n%2!=0:
            res =res+nums[int(n/2)]
        gt = res
        return {"question": question,
                "gt": gt,
                "nums": nums}
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        nums = data["nums"]
        n = len(nums)
        res = 0
        i = 0
        output = self.initialize.format(nums, n)
        while i < int(n/2):
            cnt = len(str(nums[n-i-1]))
            output += self.one_iteration_2_1.format(i, n, int(n/2), nums, n, i, n-i-1, nums[n-i-1], nums[n-i-1], cnt, nums, i, res, nums[i], cnt, res+nums[i]*(10**cnt))
            res = res+nums[i]*(10**cnt)
            output += self.one_iteration_2_1_2.format(nums, n, i, res, n-i-1, res, nums[n-i-1], res+nums[n-i-1], i, i+1)
            res = res+nums[n-i-1]
            i += 1
        output += self.complete_loop.format(i, n, int(n/2))
        if n%2!=0:
            output += self.judge_1.format(n, n%2, n, int(n/2), res, nums[int(n/2)], res+nums[int(n/2)])
            res =res+nums[int(n/2)]
        else:
            output += self.judge_2.format(n, n%2)
        output += self.return_result.format(res, res)

        return {"input": input,
                "output": output,
                "answer": res}
Generator = Dataset_Generator()
length = 10
data = Generator.gen_data_from_len(length)
print(data)

sample = Generator.rfft_IO(data)
print(sample["input"], sample["output"])