
import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2582  
        self.name =  'pass_pillow'  
        self.description = "find who has the pillow after certain seconds"  
        self.url = "https://leetcode.com/problems/pass-the-pillow/description/"
         
        self.rule = '''
def passPillow(n, time):
# Initialize variables
time %= (n - 1) * 2
# Judge
if time < n:
    num = time + 1
else:
    num = n * 2 - time - 1
# Return
return num'''
        self.initialize = '''
1. Initialize variables
n = {}
time = {}
```
time %= (n - 1) * 2
```
time = time % ((n - 1) * 2) = {} % (({} - 1) * 2) = {}
2. Judge'''
        self.judge_1 = '''
2.1 one iteration
```
if time < n:
```
time = {} < n = {}
enter
```
num = time + 1
```
num = time + 1 = {} + 1 = {}'''
        self.judge_2 = '''
2.2 one iteration
```
if time < n:
```
time = {} >= n = {}
do not enter
```
else:
num = n * 2 - time - 1
```
num = n * 2 - time - 1 = {} * 2 - {} - 1 = {}'''
        self.return_result = '''
3. Return Result
```
return num
```
num = {}
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        time = random.randint(1, 100)
        n = length
        question = f"There are n people standing in a line, numbered from 1 to n, with the first person at the front holding a pillow. Every second, the person holding the pillow passes it to the next person in line. Once the pillow reaches the front or the back of the line, the direction of passing changes, and the line continues passing the pillow in the opposite direction. The problem requires returning the number of the person holding the pillow after {time}s."
        time_bk = time
        time %= (n - 1) * 2
        if time < n:
            num = time + 1
        else:
            num = n * 2 - time - 1
        gt = num
        return {"question": question,
                "gt": gt,
                "time": time_bk,
                "n": n}
        
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        time = data["time"]
        n = data["n"]
        output = self.initialize.format(n, time, time, n, time%((n-1)*2))
        time %= (n - 1) * 2
        if time < n:
            num = time + 1
            output += self.judge_1.format(time, n, num, time, time + 1)
        else:
            num = n * 2 - time - 1
            output += self.judge_2.format(time, n, n, time, n*2 - time - 1)
        output += self.return_result.format(num, num)
        return {"input": input,
                "output": output,
                "answer": num}
    
