
import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2609  
        self.name =  'balenced_string'  
        self.description = "Find the longest balanced substring in a given string."  
        self.url = "https://leetcode.com/problems/find-the-longest-balanced-substring-of-a-binary-string/description/"
         
        self.rule ='''
def findTheLongestBalancedSubstring(s):
    ans = 0
    i = 0
    n = len(s)
    while i < n:
        a = 0
        b = 0
        while i < n and s[i] == '0':
            a += 2
            i += 1
        while i < n and s[i] == '1':
            b += 2
            i += 1
        ans = max(ans, min(a, b))
    return ans'''
        self.initialize = '''
1. Initialize variables
s = '{}'
```
ans = 0
i = 0
n = len(s)
```
s = '{}'
len(s) = {}
n = len(s) = {}
2. Main loop'''
        self.one_iteration_2_1 = '''
2.1 one iteration
```
while i < n:
```
i = {} < n = {}
enter
```
a = 0
b = 0
```'''
        self.one_iteration_2_2 = '''
2.2 update ans
```
ans = max(ans, min(a, b))
```
ans = {}
a = {}
b = {}
min(a, b) = {}
ans = max(ans, min(a, b)) = max({}, min({}, {})) = max({}, {}) = {}'''
        self.one_iteration_2_1_1_not_enter = '''
2.1.1 one iteration
```
while i < n and s[i] == '0':
```
i = {}
s = '{}'
s[i] = '{}' != '0'
do not enter'''
        self.one_iteration_2_1_1 = '''
2.1.1 one iteration
```
while i < n and s[i] == '0':
```
i = {} < n = {}
s = '{}'
s[i] = '{}' == '0'
enter
```
a += 2
i += 1
```
a = {}
i = {}
a = a + 2 = {}
i = i + 1 = {}'''
        self.complete_loop_2_1_1_n = '''
2.1.1 one iteration
```
while i < n and s[i] == '0':
```
n = {}
i = {} == n = {}
do not enter'''
        self.complete_loop_2_1_1_s = '''
2.1.1 one iteration
```
while i < n and s[i] == '0':
```
s = '{}'
i = {}
s[i] = '{}' != '0'
do not enter'''
        self.one_iteration_2_1_2_not_enter_s = '''
2.1.2 one iteration
```
while i < n and s[i] == '1':
```
i = {}
s = {}
s[i] = '{}' != '1'
do not enter'''
        self.one_iteration_2_1_2_not_enter_n = '''
2.1.2 one iteration
```
while i < n and s[i] == '1':
```
i = {} == n = {}
do not enter'''
        self.one_iteration_2_1_2 = '''
2.1.2 one iteration
```
while i < n and s[i] == '1':
```
i = {} < n = {}
s = '{}'
s[i] = '{}' == '1'
enter
```
b += 2
i += 1
```
b = {}
i = {}
b = b + 2 = {}
i = i + 1 = {}'''
        self.complete_loop_2_1_2_n = '''
2.1.2 one iteration
```
while i < n and s[i] == '1':
```
n = {}
i = {} == n = {}
do not enter'''
        self.complete_loop_2_1_2_s = '''
2.1.2 one iteration
```
while i < n and s[i] == '1':
```
s = '{}'
i = {}
s[i] = '{}' != '1'
do not enter'''
        self.complete_loop_2_1 = '''
3. complete loop
```
while i < n:
```
i = {} == n = {}
do not enter'''
        self.return_result = '''
4. Return Result
```
return ans
```
ans = {}
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        s = ''.join(random.choices(['0', '1'], k=length))
        question = f"A string consists of '0' and '1' is '{s}', what's the length of the longest balanced substring? (Balanced substring means all 0 are in front of 1 and the number of 0 is equal to the number of 1)"
        ans = 0
        i = 0
        n = len(s)
        while i < n:
            a = 0
            b = 0
            while i < n and s[i] == '0':
                a += 2
                i += 1
            while i < n and s[i] == '1':
                b += 2
                i += 1
            ans = max(ans, min(a, b))
        gt = ans
        return {"question": question,
                "gt": gt,
                "s": s}
        
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        s = data["s"]
        ans = 0
        i = 0
        n = len(s)
        output = self.initialize.format(s, s, len(s), n)
        while i < n:
            a = 0
            b = 0
            output += self.one_iteration_2_1.format(i, n)

            if s[i] != '0':
                output += self.one_iteration_2_1_1_not_enter.format(i, s, s[i])
            while i < n and s[i] == '0':
                output += self.one_iteration_2_1_1.format(i, n, s, s[i], a, i, a+2, i+1)
                a += 2
                i += 1
                if i == n:
                    output += self.complete_loop_2_1_1_n.format(n, i, n)
                    break
                if s[i] != '0':
                    output += self.complete_loop_2_1_1_s.format(s, i, s[i])
                    break

            if i == n:
                output += self.one_iteration_2_1_2_not_enter_n.format(i, n)
            elif s[i] != '1':
                output += self.one_iteration_2_1_2_not_enter_s.format(i, s, s[i])
            while i < n and s[i] == '1':
                output += self.one_iteration_2_1_2.format(i, n, s, s[i], b, i, b+2, i+1)
                b += 2
                i += 1
                if i == n:
                    output += self.complete_loop_2_1_2_n.format(n, i, n)
                    break
                if s[i] != '1':
                    output += self.complete_loop_2_1_2_s.format(s, i, s[i])
                    break
            ans_bk = ans
            ans = max(ans, min(a, b))
            output += self.one_iteration_2_2.format(ans_bk, a, b, min(a, b), ans_bk, a, b, ans_bk, min(a, b), ans)

        output += self.complete_loop_2_1.format(i, n)
        output += self.return_result.format(ans, ans)
        answer = ans
        return {"input": input,
                "output": output,
                "answer": answer}
    


