import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2645
        self.name = 'addMinimum'
        self.description = 'Given a string word to which you can insert letters "a", "b" or "c" anywhere and any number of times, return the minimum number of letters that must be inserted so that word becomes valid.'
        self.url = 'https://leetcode.com/problems/minimum-additions-to-make-valid-string/'

        self.rule = '''
def addMinimum(self, word: str) -> int:
    ans = ord(word[0]) - ord(word[-1]) + 2
    word = list(word)
    if len(word) < 2:
        return ans
    x = word.pop(0)
    y = word.pop(0)
    ans += (ord(y) - ord(x) + 2) % 3
    while word:
        x = y
        y = word.pop(0)
        ans += (ord(y) - ord(x) + 2) %3
    return ans'''
        self.initialize_in = '''
1. Initialize
```
ans = ord(word[0]) - ord(word[-1]) + 2
```
ans = {}
```
word = list(word)
```
word = {}
```
if len(word) < 2:
```
len(word) = {} < 2
enter
```
return ans
```
So the answer is {}.'''
        self.initialize_not_in = '''
1. Initialize
```
ans = ord(word[0]) - ord(word[-1]) + 2
```
ans = {}
```
word = list(word)
```
word = {}
```
if len(word) < 2:
```
len(word) = {} >= 2
not enter
```
x = word.pop(0)
```
x = '{}'
```
y = word.pop(0)
```
y = '{}'
```
ans += (ord(y) - ord(x) + 2) % 3
```
ans = {}
```
2. Main loop'''
        self.interation = '''
2.{} one interation
```
while word:
```
word = {}
enter
```
x = y
```
x = '{}'
```
y = word.pop(0)
```
y = '{}'
```
ans += (ord(y) - ord(x) + 2) %3
```
ans = {}'''
        self.not_enter_loop = '''
2.{} one interation
```
while word:
```
word = {}
not enter'''
        self.return_result = '''
3. Return result
```
return ans
```
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        word = ''.join(random.choices(['a','b','c'], k=length))
        question = f'''word = "{word}". Given a string word to which you can insert letters "a", "b" or "c" anywhere and any number of times, return the minimum number of letters that must be inserted so that word becomes valid.'''
        return {"question": question,
                "word":word}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        word = data["word"]
        ans = ord(word[0]) - ord(word[-1]) + 2
        word = list(word)
        if len(word) < 2:
            output = self.initialize_in.format(ans,word,len(word),ans)
            answer = ans
        else:
            x = word.pop(0)
            y = word.pop(0)
            ans1 = ans
            ans += (ord(y) - ord(x) + 2) % 3
            output = self.initialize_not_in.format(ans1,word,len(word)+2,x,y,ans)
            i = 1
            while word:
                word1 = word.copy()
                x = y
                y = word.pop(0)
                ans += (ord(y) - ord(x) + 2) % 3
                output += self.interation.format(i,word1,x,y,ans)
                i += 1
            if not word:
                output += self.not_enter_loop.format(i,word)
            output += self.return_result.format(ans)
            answer = ans
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2645.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))