import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2678
        self.name = "countSeniors"
        self.description = '''Given a 0-indexed array of strings details. Each element of details provides information about a given passenger compressed into a string of length 15. The eleventh and twelfth digits represent the ages of the person. What's the number of the olders?'''
        self.url = '''https://leetcode.com/problems/number-of-senior-citizens/description/'''
        self.rule = '''
def countSeniors(self, details: list) -> int:
    count = 0
    while details:
        massage = details.pop(0)
        massage_list = list(massage)
        age = int(massage_list[11]+massage_list[12])
        if age > 60:
            count += 1
    return count'''
        self.initialize = '''
1. We need to count the number of people who are seniors.
```
count = 0
```
2. Main loop'''
        self.one_iteration_2_1_find_the_olders = '''
2.{} one iteration
```
while details:
```
details = {}
enter
```
massage = details.pop(0)
```
massage = '{}'
```
massage_list = list(massage)
```
massage_list = {}
```
age = int(massage_list[11]+massage_list[12])
```
age = int(massage_list[11]+massage_list[12]) = int('{}'+'{}') = {}
```
if age > 60:
```
age = {}
age > 60
enter
```
count += 1
```
count = {}'''
        self.one_iteration_2_1_not_find_the_olders = '''
2.{} one iteration
```
while details:
```
details = {}
enter
```
massage = details.pop(0)
```
massage = '{}'
```
massage_list = list(massage)
```
massage_list = {}
```
age = int(massage_list[11]+massage_list[12])
```
age = int(massage_list[11]+massage_list[12]) = int('{}'+'{}') = {}
```
if age > 60:
```
age = {}
age <= 60
not enter'''
        self.not_enter_loop = '''
2.{} one iteration
```
while details:
```
details = {}
not enter'''
        self.return_result = '''
3. Return result.
```
return count
```
count = {}
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","details"
        '''
        import string
        numbers = string.digits
        details = []
        for i in range(length):
            detail = ''.join(random.choices(numbers,k=10))+''.join(random.choice(['F','M']))+''.join(random.choices(numbers,k=2))+''.join(random.choices(numbers,k=2))
            details.append(detail)

        question = f"details = {details} The eleventh and twelfth digits represent the ages of the person. What's the number of the olders?"

        return {"question": question,
                "details": details}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        count = 0
        details = data["details"]
        output = self.initialize
        i = 1
        while details:
            details_copy = deepcopy(details)
            massage = details.pop(0)
            massage_list = list(massage)
            age = int(massage[11]+massage[12])
            if age > 60:
                output += self.one_iteration_2_1_find_the_olders.format(i,details_copy,massage,massage_list,massage[11],massage[12],age,age,count+1)
                count += 1
            else:
                output += self.one_iteration_2_1_not_find_the_olders.format(i,details_copy,massage,massage_list,massage[11],massage[12],age,age)
            i += 1
        if not details:
            output += self.not_enter_loop.format(i,details)
        output += self.return_result.format(count,count)
        return {"input": input,
                "output": output,
                "answer": count}


if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2678.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))