import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2682
        self.name = "Circular_Game"
        self.description = '''There are n friends,sitting in a circle and numbered from 1 to n in clockwise order, playing the sircular game. Start at 1st friend and end at 1st friend receive the ball again. What is the serial number of the friend who hasn't caught the ball?'''
        self.url = '''https://leetcode.com/problems/find-the-losers-of-the-circular-game/description/'''
        self.rule = '''
def Circular_Game(n: int,k: int) -> list[int]
    n = eval(input())
    k = eval(input())
    judge = [False]*n
    i = 0
    d = 1
    while not judge[i]:
        judge[i] = True
        i = (i+d*k)%n
        if judge[i]:
            break
        d += 1
    return [i+1 for i in range(n) if not judge[i]]'''
        self.initialize = '''
1. Initialize n and k State
```
n = eval(input())
```
n = {}
```
k = eval(input())
```
k = {}
```
judge = [False]*n
```
judge = [False]*n = [False]*{} = {}
```
i = 0
```
```
d = 1
```
2. Main Loop'''
        self.one_iteration_2_1_end = '''
2.{} one iteration
```
while not judge[i]:
```
i = {}
not judge[i] == True
enter
```
judge[i] = True
```
judge[{}] = True
```
i = (i+d*k)%n
```
i = (i+d*k)%n = ({}+{}*{})%{} = {}
```
if judge[i]:
```
jugde[i] = jugde[{}] == True
enter
```
break
```'''
        self.one_iteration_2_1_not_end = '''
2.{} one iteration
```
while not judge[i]:
```
i = {}
not judge[i] = True
enter
```
judge[i] = True
```
judge[{}] = True
```
i = (i+d*k)%n
```
i = (i+d*k)%n = ({}+{}*{})%{} = {}
```
if judge[i]:
```
jugde[i] = jugde[{}] == False
not enter
```
d += 1
```
d = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while not judge[i]:
```
i = {}
not judge[i] = False
not enter'''
        self.return_result = '''
3. return result
```
return [i+1 for i in range(n) if not judge[i]]
```
judge = {}
return [i+1 for i in range({}) if not judge[i]] = [i+1 for i in range({}) if not {}] = {}
So the answer is {}.'''

    def gen_data_from_len(self,length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","n","k"
        '''
        length_ = random.choice(range(2,7))
        n = random.choice(range(1,length))
        k = random.choice(range(1,length_))
        question = f"n = {n}.k = {k}. What is the serial number of the friend who hasn't caught the ball?"
        return {"question": question,
                "n": n,
                "k": k}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        n = data['n']
        k = data['k']
        judge = [False]*n
        i = 0
        d = 1
        output = self.initialize.format(n,k,n,judge)
        while not judge[i]:
            judge[i] = True
            i_ = i
            i = (i+d*k)%n
            if judge[i]:
                output += self.one_iteration_2_1_end.format(d,i_,i_,i_,d,k,n,i,i)
                break
            output += self.one_iteration_2_1_not_end.format(d,i_,i_,i_,d,k,n,i,i,d+1)
            d += 1
        if judge[i]:
            output += self.not_enter_loop.format(d+1,i)
        answer = [i+1 for i in range(n) if not judge[i]]
        output += self.return_result.format(judge,n,n,judge[i],answer,answer)
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2682.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))