import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2785
        self.name = 'sortVowels'
        self.description = 'Given a 0-indexed string s, permute s to get a new string t such that: All consonants remain in their original places. The vowels must be sorted in the nondecreasing order of their ASCII values.'
        self.url = 'https://leetcode.com/problems/sort-vowels-in-a-string/'

        self.rule = '''
def sortVowels(self, s: str) -> str:
    s = list(s)
    s_copy = s.copy()
    vowel_list = []
    ans = []
    while s_copy:
        a = s_copy.pop(0)
        if a.lower() in 'aeiou':
            vowel_list.append(ord(a))
    vowel_list.sort()
    while s:
        a = s.pop(0)
        if a.lower() in 'aeiou':
            ans.append(chr(vowel_list.pop(0)))
        else:
            ans.append(a)
    return ''.join(ans)'''
        self.initialize = '''
1. Initialize
```
s = list(s)
```
s = {}
```
s_copy = s.copy()
```
s_copy = {}
```
vowel_list = []
```
```
ans = []
```
2. Main loop one'''
        self.interation_one_in = '''
2.{} one interation
```
while s_copy:
```
s_copy = {}
enter
```
a = s_copy.pop(0)
```
a = '{}'
```
if a.lower() in 'aeiou':
```
a.lower() = '{}'
a.lower() in 'aeiou'
enter
```
vowel_list.append(ord(a))
```
vowel_list = {}
```'''
        self.interation_one_not_in = '''
2.{} one interation
```
while s_copy:
```
s_copy = {}
enter
```
a = s_copy.pop(0)
```
a = '{}'
```
if a.lower() in 'aeiou':
```
a.lower() = '{}'
a.lower() not in 'aeiou'
not enter'''
        self.not_enter_loop1 = '''
2.{} one interation
```
while s_copy:
```
s_copy = {}
not enter'''
        self.sort = '''
3. Sort
```
vowel_list.sort()
```
vowel_list = {}
4. Main loop two'''
        self.interation_two_in = '''
4.{} one interation
```
while s:
```
s = {}
enter
```
a = s.pop(0)
```
a = '{}'
```
if a.lower() in 'aeiou':
```
a.lower() = '{}'
a.lower() in 'aeiou'
enter
```
ans.append(chr(vowel_list.pop(0)))
```
ans = {}
```'''
        self.interation_two_not_in = '''
4.{} one interation
```
while s:
```
s = {}
enter
```
a = s.pop(0)
```
a = '{}'
```
if a.lower() in 'aeiou':
```
a.lower() = '{}'
a.lower() not in 'aeiou'
not enter
```
else:
    ans.append(a)
```
ans = {}'''
        self.not_enter_loop2 = '''
4.{} one interation
```
while s:
```
s = {}
not enter'''
        self.return_result = '''
5. Return result
```
return ''.join(ans)
```
return '{}'

So the answer is '{}'.'''


    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        import string
        s = ''.join(random.choices(string.ascii_letters, k=length))
        question = f'''s = "{s}". Given a 0-indexed string s, permute s to get a new string t such that: All consonants remain in their original places. The vowels must be sorted in the nondecreasing order of their ASCII values.'''
        return {"question": question,
                "s": s}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        s = data["s"]
        s = list(s)
        s_copy = s.copy()
        vowel_list = []
        ans = []
        output = self.initialize.format(s,s_copy)
        i = 1
        while s_copy:
            s_copy_copy = s_copy.copy()
            a = s_copy.pop(0)
            if a.lower() in 'aeiou':
                vowel_list.append(ord(a))
                output += self.interation_one_in.format(i,s_copy_copy,a,a.lower(),vowel_list)
            else:
                output += self.interation_one_not_in.format(i,s_copy_copy,a,a.lower())
            i += 1
        if not s_copy:
            output += self.not_enter_loop1.format(i,s_copy)
        vowel_list.sort()
        i = 1
        output += self.sort.format(vowel_list)
        while s:
            s_copy = s.copy()
            a = s.pop(0)
            if a.lower() in 'aeiou':
                ans.append(chr(vowel_list.pop(0)))
                output += self.interation_two_in.format(i,s_copy,a,a.lower(),ans)
            else:
                ans.append(a)
                output += self.interation_two_not_in.format(i,s_copy,a,a.lower(),ans)
            i += 1
        if not s:
            output += self.not_enter_loop2.format(i,s)
        answer = ''.join(ans)
        output += self.return_result.format(answer,answer)

        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/2785.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))