import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2833  
        self.name = 'Furthest Point From Origin'
        self.description = 'Find the furthest point from origin after given moves'
        self.url='https://leetcode.com/problems/furthest-point-from-origin/description/'
        self.question='''Q:"R"rerepresent move towards right,"_"represent move towards any direction  ,"L"represent move towards left (all 1 step)
        Find the furthest distance you can get from origin
        '''
        self.data="The given moving actions are {}"
        self.instruction="Follow the given rules to find the answer\n rules:"
        self.rule='''
def furthestDistanceFromOrigin(self, moves: str) -> int:
    step=0
    right=0
    left=0
    extra_step=0
    distance=0
    iteration_time=0
    while iteration_time<len(moves):
        choice=moves[iteration_time]
        if choice=='R':
            right+=1
        elif choice=='L':
            left+=1
        else:
            step+=1
        iteration_time+=1
    extra_step=abs(left-right)
    distance=extra_step+step
    return distance
'''
        self.initialize='''
1.Initialize step,right,left,extra_step,distance,iteration_time,moves
```
step=0
right=0
left=0
extra_step=0
distance=0
iteration_time=0
moves={}
```
2.Main loops'''
        
        self.iteration_2_1_enter='''
2.1 One iteration
```
while iteration_time<len(moves):
```
iteration_time={0}
len(moves)={1}
iteration_time<len(moves)
enter
```
choice=moves[iteration_time]
```
choice={2}'''
        self.iteration_2_1__do_not_enter='''
2.1 One iteration
```
while iteration_time<len(moves):
```
iteration_time={0}
len(moves)={1}
iteration_time=len(moves)
do not enter
```
extra_step=abs(left-right)
```
extra_step=abs({2}-{3})={4}
```
distance=extra_step+step
```
distance={4}+{5}={6}

So the answer is {6}'''
        self.IF_statement_if='''
IF_statement
```
if choice=='R':
```
choice={0}
choice=='R'
enter
```
right+=1
```
right={2}+1={1}'''
        self.IF_statement_elif='''
IF_statement
```
if choice=='R':
```
choice={0}
choice!='R'

do not enter
```
elif choice=='L':
```
choice={0}
choice=='L'
enter
```
left+=1
```
left={2}+1={1}'''
        self.IF_statement_else='''
IF_statement
```
if choice=='R':
```
choice={0}
do not enter
```
elif choice=='L':
```
choice={0}
choice!='L'
do not enter
```
else:
```
enter
```
step+=1
```
step={2}+1={1}'''
    def gen_data_from_len(self,length)->list:
        '''
        return datapoint of given length
        '''
        moves=''
        for j in range(length):
            moves+=random.choice(['R','L','_','_'])
        return moves 
    def rfft_IO(self, moves: str) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input=self.question+self.data.format(moves)+self.instruction+self.rule
        output=self.question
        output+=self.initialize.format(moves)
        step=0
        right=0
        left=0
        extra_step=0
        distance=0
        iteration_time=0
        
        while iteration_time<len(moves):
            choice=moves[iteration_time]
            output+=self.iteration_2_1_enter.format(iteration_time,len(moves),choice)
            if choice=='R':
                right+=1
                output+=self.IF_statement_if.format(choice,right,right-1)
            elif choice=='L':
                left+=1
                output+=self.IF_statement_elif.format(choice,left,left-1)
            else:
                step+=1
                output+=self.IF_statement_else.format(choice,step,step-1)
            iteration_time+=1
        extra_step=abs(left-right)
        distance=extra_step+step
        output+=self.iteration_2_1__do_not_enter.format(iteration_time,len(moves),left,right,extra_step,step,distance)
        return {"input":input,
                "output":output,
                'answer':distance}