
import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2869  
        self.name =  'minimum operation'  
        self.description = "find minimum operation to collect elements"  
        self.url = 'https://leetcode.com/problems/minimum-operations-to-collect-elements/description/'
         
        self.rule = '''
def minimum_operations(nums, k):
# Initialize variables
u = (2 << k) - 2
s = 0
n = len(nums)
i = n - 1
while i >= 0:
    s |= 1 << nums[i]
    if (s & u) == u:
        ans = n - i
        return ans
    i -= 1
    if i < 0:
        ans = -1
        return ans
'''
        self.initialize = '''
nums = {}
k = {}
1. Initialize variables
```
u = (2 << k) - 2  # 1~k
s = 0
n = len(nums)
i = n - 1
```
2 << k = {}
u = (2 << k) - 2 = {} - 2 = {}
s = 0
nums = {}
n = len(nums) = {}
i = n - 1 = {} - 1 = {}
2. Main loop'''
        self.one_iteration_2 = '''
```
while i >= 0:
```
i = {} >= 0
enter
```
s |= 1 << nums[i]
```
nums = {}
s |= 1 << nums[i] = s | 1 << nums[{}] = s | (1 << {}) = {} | (1 << {}) = {} | {} = {}'''
        self.judge_1_1 = '''
```
if (s & u) == u:
```
s & u = {} & {} = {} == u = {}
enter
```
ans = n - i
```
ans = n - i = {} - {} = {}
3. Return
```
return ans
```
ans = {}
So the answer is {}.'''
        self.judge_1_2 = '''
```
if (s & u) == u:
```
s & u = {} & {} = {} != u = {}
do not enter
```
i -= 1
```
i -= 1 = i-1 = {}-1 = {}
```'''
        self.judge_2_1 = '''
```
if i < 0:
```
i = {} < 0
enter
```
ans = -1
return ans
```
ans = -1
3. Return
```
return ans
```
ans = {}
So the answer is {}.'''
        self.judge_2_2 = '''
```
if i < 0:
```
i = {} >= 0
do not enter
```'''

    def gen_data_from_len(self, length: int) -> dict:
        nums = random.sample([i for i in range(1, length+1)]*2, k=int(length*1.9))
        k = random.randint(3, length)
        question = f'An array {nums} and an integer {k}. In one operation, you can remove the last element of the array and add it to your collection. Answer the minimum number of operations needed to collect elements [1, 2, ..., {k}], if no answer is possible, return -1.'
        u = (2 << k) - 2  # 1~k
        s, n = 0, len(nums)
        i = n-1
        while i >= 0:
            s |= 1 << nums[i]
            if (s & u) == u:
                ans = n - i
                break
            i -= 1
            if i < 0:
                ans = -1
        return {"question": question,
                "gt": ans,
                "nums": nums,
                "k": k
        }
        
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        nums = data["nums"]
        k = data["k"]
        output = self.initialize.format(nums, k, 2<<k, 2<<k, (2<<k) - 2, nums, len(nums), len(nums), len(nums)-1)
        u = (2 << k) - 2  # 1~k
        s = 0
        n = len(nums)
        i = n - 1
        while i >= 0:
            output += self.one_iteration_2.format(i, nums, i, nums[i], s, nums[i], s, 1<<nums[i], s | 1 << nums[i])
            s |= 1 << nums[i]
            if (s & u) == u:
                output += self.judge_1_1.format(s, u, s&u, u, n, i, n-i, n-i, n-i)
                ans = n - i
                break
            else:
                output += self.judge_1_2.format(s, u, s&u, u, i, i-1)
            i -= 1
            if i < 0:
                output += self.judge_2_1.format(i, -1, -1)
                ans = -1
                break
            else:
                output += self.judge_2_2.format(i)
        return {"input": input,
                "output": output, 
                "answer": ans}

Generator = Dataset_Generator()
length = 10
data = Generator.gen_data_from_len(length)
print(data)

sample = Generator.rfft_IO(data)
print(sample["input"], sample["output"])