
import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2899  
        self.name =  'last_visited'  
        self.description = "Find for each -1 the respective positive integer"  
        self.url = 'https://leetcode.com/problems/last-visited-integers/description/'
         
        self.rule = '''
def last_visited(nums):
# Initialize variables
ans = []
seen = []
k = 0
# Main loop
while nums:
    x = nums.pop(0)
    if x > 0:
        seen.append(x)
        k = 0
    else:
        k += 1
        if k > len(seen):
            t = -1
        else:
            t = seen[-k]
        ans.append(t)
# Return
return ans'''
        self.initialize = '''
1. Initialize variables
nums = {}
```
ans = []
seen = []
k = 0
```
2. Main loop'''
        self.one_iteration_2_1 = '''
2.1 one iteration
```
while nums:
```
nums = {} != None
enter
```
x = nums.pop(0)
```
x = nums.pop(0) = nums[0] = {}
nums = nums[1:] = {}
```'''
        self.one_iteration_2_1_1 = '''
```
if x > 0:
```
x = {} > 0
enter
```
seen.append(x)
```
seen.append(x) = seen.append({})
seen = {} + {} = {}
```
k = 0
```
k = 0
```'''
        self.one_iteration_2_1_2_big = '''
```
if x > 0:
```
x = {} <= 0
do not enter
```
else:
k += 1
```
k += 1 = k+1 = {}+1 = {}
```
if k > len(seen):
```
seen = {}
k = {} > len(seen) = {}
enter
```
t = -1
```
t = -1
```
ans.append(t)
```
ans.append(t) = ans.append(-1)
ans = {} + [-1] = {}
'''
        self.one_iteration_2_1_2_small = '''
```
if x > 0:
```
x = {} <= 0
do not enter
```
else:
k += 1
```
k += 1 = k+1 = {}+1 = {}
```
if k > len(seen):
```
seen = {}
k = {} <= len(seen) = {}
do not enter
```
else:
t = seen[-k]
```
seen = {}
t = seen[-k] = seen[{}] = {}
```
ans.append(t)
```
ans.append(t) = ans.append({})
ans = {} + {} = {}
'''
        self.complete_loop = '''
3. Complete Loop
```
while nums:
```
nums = {} == none
do not enter
```          '''
        self.return_result = '''
4. Return Result
```
resturn ans
```
ans = {}

So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        nums = random.choices([-1]*40+[i for i in range(1, 100)], k=length)
        question = f"an integer array {nums} . Find for each -1 the respective positive integer, which we call the last visited integer."
        ans = []
        seen = []
        k = 0
        nums_bk = nums.copy()
        while nums:
            x = nums.pop(0)
            if x > 0:
                seen.append(x)
                k = 0
            else:
                k += 1
                if k > len(seen):
                    t = -1
                else:
                    t = seen[-k]
                ans.append(t)
        return {"question": question,
                "gt": ans,
                "nums": nums_bk}
        
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        nums = data["nums"]    
        ans = []
        seen = []
        k = 0
        output = self.initialize.format(nums)
        while nums:
            output += self.one_iteration_2_1.format(nums, nums[0], nums[1:])
            x = nums.pop(0)
            if x > 0:
                output += self.one_iteration_2_1_1.format(x, x, seen, [x], seen+[x])
                seen.append(x)
                k = 0
            else:
                if k > len(seen)-1:
                    output += self.one_iteration_2_1_2_big.format(x, k, k+1, seen, k+1, len(seen), ans, ans + [-1])
                    k += 1
                    t = -1
                else:
                    output += self.one_iteration_2_1_2_small.format(x, k, k+1,seen, k+1, len(seen), seen, -k-1, seen[-k-1], seen[-k-1], ans, [seen[-k-1]], ans + [seen[-k-1]])
                    k += 1
                    t = seen[-k]
                ans.append(t)  
            if not nums:
                output += self.complete_loop.format(nums)
        output += self.return_result.format(ans,ans)
        return {"input": input,
                "output": output,
                "answer": ans}

Generator = Dataset_Generator()
length = 10
data = Generator.gen_data_from_len(length)
print(data)

sample = Generator.rfft_IO(data)
print(sample["input"], sample["output"])