import random
import string


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 3271  
        self.name = 'Hash Divided String'
        self.description = 'Conduct hash exchange on the given string'
        self.url='https://leetcode.com/problems/hash-divided-string/description/'
        self.question='''Q:\nYou are given a string s of length n and an integer k, where n is a multiple of k. Your task is to hash the string s into a new string called result, which has a length of n / k.

First, divide s into n / k substrings, each with a length of k.
For each substring in order from the beginning:
The hash value of a character is the index of that character in the English alphabet (e.g., 'a' → 0, 'b' → 1, ..., 'z' → 25).
Calculate the sum of all the hash values of the characters in the substring.
Find the remainder of this sum when divided by 26, which is called hashedChar.
Identify the character in the English lowercase alphabet that corresponds to hashedChar.
Append that character to the end of result.
Find out the new string.'''
        self.data='''The given string s is {0}\nThe given integer k is {1}\n'''

        self.instruction='''Follow the given rule to solve this problem.\nrule:'''
        self.rule='''
def stringHash(self, s: str, k: int) -> str:
    result=[]
    s_list=[i for i in s]
    while s_list:
        time=0
        sum_hash=0
        while time<k:
            letter=s_list.pop(0)
            letter_hash=ord(letter)-ord('a')
            sum_hash+=letter_hash
            time+=1
        hashchar=sum_hash%26
        hashchar_letter=chr(hashchar+ord('a'))
        result.append(hashchar_letter)
    return ''.join(result)
'''
        self.initialize='''
1.Initialize s,k,result,s_list
```
s={0}
k={1}
result=[]
s_list=[i for i in s]
```
s_list={2}

2.Main loops
'''
        self.iteration_2_1_enter='''
2.1 One iteration
```
while s_list:
```
s_list={0}
True
enter
```
time=0
sum_hash=0
```
'''
        self.iteration_2_1_do_not_enter='''
2.1 One iteration
```
while s_list:
```
s_list=[]
False
do not enter

So the answer is {}
'''
        self.iteration_2_1_1_enter='''
2.1.1 One iteration
```
while time<k:
```
time={0}
k={1}
{0}<{1}
enter
```
letter=s_list.pop(0)
```
letter={2}
s_list={3}
```
letter_hash=ord(letter)-ord('a')
```
letter_hash={4}-{5}={6}
```
sum_hash+=letter_hash
```
sum_hash={7}+{6}={8}
```
time+=1
```
time={9}+1={10}
'''
        self.iteration_2_1_1_do_not_enter='''
2.1.1 One iteration
```
while time<k:
```
time={0}
k={1}
{0}=={1}
do not enter
'''
        self.iteration_2_1_1_enter_inside='''
```
hashchar=sum_hash%26
```
hashchar={0}%26={1}
```
hashchar_letter=chr(hashchar+ord('a'))
```
hashchar_letter=chr({2}+{3})=chr({4})={5}
```
result.append(hashchar_letter)
```
result={6}
'''
    def gen_data_from_len(self, length: int) :
        '''
        return datapoint of given length

        return {...}
        '''
        k=length*random.randint(2,4)
        s=''.join(random.choices(string.ascii_lowercase,k=k))
        return (s,k)
    def rfft_IO(self, ttmp) -> str:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data

        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        s,k=ttmp
        input=self.question+self.data.format(s,k)+self.instruction+self.rule
        result=[]
        s_list=[i for i in s]
        output=self.question+self.initialize.format(s,k,s_list)
        while s_list:
            time=0
            sum_hash=0
            output+=self.iteration_2_1_enter.format(s_list)
            while time<k:
                letter=s_list.pop(0)
                letter_hash=ord(letter)-ord('a')
                sum_hash+=letter_hash
                time+=1
                output+=self.iteration_2_1_1_enter.format(time,k,letter,s_list,ord(letter),ord('a'),letter_hash,sum_hash-letter_hash,sum_hash,time-1,time)

            output+=self.iteration_2_1_1_do_not_enter.format(time,k)
            hashchar=sum_hash%26
            hashchar_letter=chr(hashchar+ord('a'))
            result.append(hashchar_letter)
            output+=self.iteration_2_1_1_enter_inside.format(sum_hash,hashchar,hashchar,ord('a'),hashchar+ord('a'),hashchar_letter,result)
        output+=self.iteration_2_1_do_not_enter.format(''.join(result))
        return {'input':input,'output':output,'answer':''.join(result)}




    