import numpy as np
np.random.seed(42)
import random
from copy import deepcopy
import string


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 896
        self.name='Monotonic_Array'
        self.description='''An array is monotonic if it is either monotone increasing or monotone decreasing.Given an integer array nums, return true if the given array is monotonic, or false otherwise.'''
        self.url="https://leetcode.com/problems/monotonic-array/description/"
        self.rule = '''
def isMonotonic(self, nums):
    # 1.Initialize
    increase = True
    decrease = True

    # 2. Main loop
    while len(nums) > 1:
        if nums[0] > nums[1]
            increase = False
        if nums[0] < nums[1]
            decrease = False
        nums = nums[1:]
    return increase or decrease
'''
        # stages
        self.initialize = '''1. Initialize
nums = {}
increase = True
decrease = True
'''
        self.enter = '''```
while len(nums) > 1:
```
nums = {}
enter the loop
2.1 One iteration
recall that increase = {}, decrease = {}
'''
        self.not_enter = '''```
while len(nums) > 1:
```
nums = {}
do not enter
'''
        self.if1_enter = '''```
if nums[0] > nums[1]:
```
nums[0] = {}
nums[1] = {}
nums[0] > nums[1] == True
enter
```
increase = False
```
increase = {}
now,
increase = False
'''
        self.if1_not_enter = '''```
if nums[0] > nums[1]:
```
nums[0] = {}
nums[1] = {}
nums[0] > nums[1] == False
do not enter
'''
        self.if2_enter = '''```
if nums[0] < nums[1]:
```
nums[0] = {}
nums[1] = {}
nums[0] < nums[1] == True
enter
```
decrease = False
```
decrease = {}
now,
decrease = False
'''
        self.if2_not_enter = '''```
if nums[0] < nums[1]:
```
nums[0] = {}
nums[1] = {}
nums[0] < nums[1] == False
do not enter
'''
        self._pop = '''```
nums = nums[1:]
```
nums = {}
now,
nums = {}
'''
        self.return_ans = '''```
return increase or decrease
```
increase = {}
decrease = {}
return {}
So the answer is {}
'''



    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including `"question", "gt", ...`
        '''
        def isMonotonic(nums: list[int]):
            increase = True; decrease = True
            while (nums[1:]):
                delta = nums[0] - nums[1]
                if (delta < 0):
                    increase = False
                if (delta > 0):
                    decrease = False
                nums = nums[1:]
            return increase or decrease
        
        def generate_array(length: int) -> list:
            '''
            generate an array of integer
            '''
            result = []
            for _ in range(length):
                result.append(random.randint(0, 100))
    
            return result

        # example question: Given an array arr = [6,5,4,4], please check whether it is monotonic (both monotone increasing and monotone decreasing are qualified)
        # example answer: true
        # here length is the length of the array
        # warning: to simulate the mechanism of stack, the algorithm can not meet the time demmand 
        true_rate = random.randint(0, 100)

        if true_rate < 50:
            arr = generate_array(length)
        else:
            arr = generate_array(length)
            if random.randint(0, 1) == 0:
                arr.sort()
            else:
                arr.sort(reverse=True)

        question = "Given an array nums = {}, please check whether it is monotonic (both monotone increasing and monotone decreasing are qualified)".format(arr)
        gt = str(isMonotonic(arr))
        return {"question": question,
            "gt": gt,
            "arr": arr}
    

    def natural_IO(self, data: dict) -> dict:
        '''
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"

        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        answer = data["gt"]
        nums = data["arr"]
        output = ""

        # 1.Initialize
        output += self.initialize.format(nums)
        increase = True; decrease = True
        while len(nums) > 1:
            output += self.enter.format(nums, increase, decrease)
            
            if nums[0] > nums[1]:
                output += self.if1_enter.format(nums[0], nums[1], increase)
                increase = False
            else:
                output += self.if1_not_enter.format(nums[0], nums[1])
            if nums[0] < nums[1]:
                output += self.if2_enter.format(nums[0], nums[1], decrease)
                decrease = False
            else:
                output += self.if2_not_enter.format(nums[0], nums[1])
            output += self._pop.format(nums, nums[1:])
            nums = nums[1:]
        output += self.not_enter.format(nums)
        output += self.return_ans.format(increase, decrease, increase or decrease, increase or decrease)
        
        return {"input": input,
                "output": output,
                "answer": answer}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"

        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        answer = data["gt"]
        nums = data["arr"]
        output = ""

        # 1.Initialize
        output += self.initialize.format(nums)
        increase = True; decrease = True
        while len(nums) > 1:
            output += self.enter.format(nums, increase, decrease)
            
            if nums[0] > nums[1]:
                output += self.if1_enter.format(nums[0], nums[1], increase)
                increase = False
            else:
                output += self.if1_not_enter.format(nums[0], nums[1])
            if nums[0] < nums[1]:
                output += self.if2_enter.format(nums[0], nums[1], decrease)
                decrease = False
            else:
                output += self.if2_not_enter.format(nums[0], nums[1])
            output += self._pop.format(nums, nums[1:])
            nums = nums[1:]
        output += self.not_enter.format(nums)
        output += self.return_ans.format(increase, decrease, increase or decrease, increase or decrease)
        
        return {"input": input,
                "output": output,
                "answer": answer}
    
    def cot_IO(self, data: dict) -> dict:
        question = data["question"]
        nums = data["arr"]
        output = "# check if the array is monotonic\n"
        output += f"nums = {nums}\n"
        increase = True
        decrease = True
        for i in range(len(nums) - 1):
            if nums[i] > nums[i + 1]:
                increase = False
                output += f"{nums[i]} > {nums[i + 1]}, so the sequence cannot be increasing\n"
            elif nums[i] < nums[i + 1]:
                decrease = False
                output += f"{nums[i]} < {nums[i + 1]}, so the sequence cannot be decreasing\n"
            else:
                output += f"{nums[i]} == {nums[i + 1]}, so the sequence status remains\n"
        answer = increase or decrease
        if increase:
            output += "The sequence is increasing\n"
        elif decrease:
            output += "The sequence is decreasing\n"
        output += f"So the answer is {answer}\n"
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(6)

    data = dg.cot_IO(data)
    print(data['input'], '\n')
    print(data['output'])