import numpy as np
import random
from copy import deepcopy
import string


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 953
        self.name = "Alien-Dictionary"
        self.description = '''Given a sequence of words written in the alien language, and the order of the alphabet, return true if and only if the given words are sorted lexicographically in this alien language.'''
        self.url = "https://leetcode.com/problems/verifying-an-alien-dictionary/description/"
        self.rule = '''
def isAlienSorted(words, order):
    # 1.Main loop
    while words[1:]:
        # Get the current pair of words on the top of the stack to compare
        word_pred = words[0]  # The preceding word
        word_succ = words[1]  # The succeeding word
        flag = 1  # Flag to check if the comparison is still ongoing
        
        # 2.Compare adjacent two words
        # Compare characters of the two words until one word is exhausted or they are not in dictionary order
        while word_pred and word_succ:
            # the order is incorrect
            if order.find(word_pred[0]) > order.find(word_succ[0]):
                return False
            
            # the order is correct and we can stop comparing
            elif order.find(word_pred[0]) < order.find(word_succ[0]):
                flag = 0
                break
            
            # the order can't be inferred from this pair of letter, move to the next one in both words
            else:
                word_pred = word_pred[1:]
                word_succ = word_succ[1:]
        
        # If we've compared all characters without a clear order and the preceding word is longer, the order is incorrect
        if flag and word_pred:
            return False
        
        # Move to the next pair of words
        words = words[1:]
    
    # If all pairs were correctly ordered, return True
    return True'''
        # stages
        self.main_loop = '''
1.Main loop\n'''
        self.adjacent_check = '''
2.Compare adjacent two words\n'''  

        # state
        self.val = '''
{} = {}\n'''
        self.mean = '''
{} means {}'''
        self.calculate = '''
{} = {}, {} = {}, so {} = {} {} {} = {}\n'''
        self.into_branch = '''
{} = {}, {} = {}, so {} {} {}, thus enter the branch—— {}\n'''
        self.neglect_branch = '''
{} = {}, so {} {} {}, thus neglect the branch\n'''
        self.into_mainiteration = '''
{} = {}, so {} {} {}, thus enter main Iteration {}:\n'''
        self.into_subiteration = '''
{} = {}, {} = {}, so both them are not NULL, thus enter main Iteration {}, sub Iteration {}:\n'''
        self.leave_iteration = '''
{} = {}, thus leave the {} iteration!\n'''
        self._pop = '''
POP the first element from {}!!! {} still has {}\n'''
        self._break = '''
leave the current subiteration\n'''
        self.answer = '''
So the answer is {}\n'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including `"question", "gt", ...`
        '''
        def isAlienSorted(words: list[str], order: str) -> bool:
            while words[1:]:
                word_pred = words[0]
                word_succ = words[1]
                flag = 1
                while word_pred and word_succ:
                    if (order.find(word_pred[0]) > order.find(word_succ[0])):
                        return False
                    elif (order.find(word_pred[0]) < order.find(word_succ[0])):
                        flag = 0
                        break
                    else:
                        word_pred = word_pred[1:]
                        word_succ = word_succ[1:]
                if (flag and word_pred):
                    return False
                words = words[1:]
            return True
        
        def generate_array(length: int, upperbound: int) -> list:
            '''
            generate an array of integer
            '''
            result = []
            for _ in range(length):
                result.append(random.randint(0, upperbound))
            return result

        def generate_alphabet(length: int) -> str:
            unique_letters = random.sample(string.ascii_lowercase, length)
            return ''.join(unique_letters)
        
        def custom_sort_key(word: list[str], order_index: dict) -> list[int]:
            return [order_index[char] for char in word]

        def words_sort(words, dicts):
            order_index = {char: index for index, char in enumerate(dicts)}
            sorted_words = sorted(words, key=lambda word: custom_sort_key(word, order_index))
            return sorted_words
        
        # example question: Given an array of words = ["word","world","row"], an alphabet order = "worldabcefghijkmnpqstuvxyz", please determine whether the word list follows the dictionary order specified by the alphabet
        # example answer: false
        # here length is the length of the word list
        words = []
        len_dict = random.randint(6, 12)
        dicts = generate_alphabet(len_dict)

        true_rate = random.randint(0, 10)

        for _ in range(length):
            arr = generate_array(random.randint(3, 6), len_dict - 1)
            words.append(''.join(dicts[x] for x in arr))
        if (true_rate > 4):
            words = words_sort(words, dicts)

        question = "Given an array of words = {}, an alphabet order = {}, please determine whether the word list follows the dictionary order specified by the alphabet".format(words, dicts)
        gt = str(isAlienSorted(words, dicts))
        return {"question": question,
            "gt": gt,
            "words": words,
            "order": dicts}

    def rfft_IO(self, data: dict) -> dict:
        '''
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"

        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        answer = data["gt"]
        words = data["words"]
        order = data["order"]
        output = ""

        # 1.Main loop
        output += self.main_loop
        iter_m = 0
        while words[1:]:
            iter_m += 1
            output += self.into_mainiteration.format("words[1:]", words[1:], "words[1:]", "!=", "NULL", iter_m)

            word_pred = words[0] 
            word_succ = words[1] 
            flag = 1  

            output += self.val.format("word_pred", word_pred)
            output += self.val.format("word_succ", word_succ)
            output += self.val.format("flag", flag)
    
            # 2.Compare adjacent two words
            output += self.adjacent_check
            iter_sub = 0
            while word_pred and word_succ:
                iter_sub += 1
                output += self.into_subiteration.format("word_pred", word_pred, "word_succ", word_succ, iter_m, iter_sub)

                if order.find(word_pred[0]) > order.find(word_succ[0]):
                    output += self.val.format("word_pred[0]", word_pred[0])
                    output += self.val.format("word_succ[0]", word_succ[0])
                    output += self.into_branch.format("word_pred[0] in order", order.find(word_pred[0]), "word_succ[0] in order", order.find(word_succ[0]), "word_pred[0]", ">(order)", 
                                            "word_succ[0]", "the order is incorrect!")
                    answer = False
                    output += self.answer.format(answer)
                    return {"input": input,
                            "output": output,
                            "answer": answer}
        
                elif order.find(word_pred[0]) < order.find(word_succ[0]):
                    output += self.val.format("word_pred[0]", word_pred[0])
                    output += self.val.format("word_succ[0]", word_succ[0])
                    output += self.into_branch.format("word_pred[0] in order", order.find(word_pred[0]), "word_succ[0] in order", order.find(word_succ[0]), "word_pred[0]", "<(order)", 
                                            "word_succ[0]", "the order is already correct!")
                    flag = 0
                    output += self.val.format("flag", flag)
                    output += self._break
                    break
        
                else:
                    output += self.val.format("word_pred[0]", word_pred[0])
                    output += self.val.format("word_succ[0]", word_succ[0])
                    output += self.into_branch.format("word_pred[0] in order", order.find(word_pred[0]), "word_succ[0] in order", order.find(word_succ[0]), "word_pred[0]", "==(order)", 
                                            "word_succ[0]", "we can't judge the order now, move to the next one!")
                    word_pred = word_pred[1:]
                    output += self._pop.format("word_pred", "word_pred", word_pred)
                    word_succ = word_succ[1:]
                    output += self._pop.format("word_succ", "word_succ", word_succ)
            if (not word_pred):
                output += self.leave_iteration.format("word_pred", "NULL", "sub")
            if (not word_succ):
                output += self.leave_iteration.format("word_succ", "NULL", "sub")
    
            if flag and word_pred:
                output += self.into_branch.format("flag", flag, "word_pred", word_pred, "the comparation is ongoing", "and", 
                                            "word_pred has more letters", "the order is incorrect!")
                answer = False
                output += self.answer.format(answer)
                return {"input": input,
                    "output": output,
                    "answer": answer}
    
            words = words[1:]
            output += self._pop.format("words", "words", words)
        
        output += self.leave_iteration.format("words", "NULL", "main")

        answer = True
        output += self.answer.format(answer)
        return {"input": input,
                "output": output,
                "answer": answer}

