import random

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 657  
        self.name = 'Robot Return to Origin'  
        self.url = 'https://leetcode.com/problems/robot-return-to-origin/description/'
         
        self.rule = '''
def robot_return_to_origin(command):
    # Initialize Coordinates
    x = 0
    y = 0
    # Main Loop
    for move in command:
        if move == 'U':
            y += 1
        elif move == 'L':
            x -= 1
        elif move == 'R':
            x += 1
        elif move == 'D':
            y -= 1
    # Return Result
    if x == 0 and y == 0:
        return True
    else:
        return False'''
        self.initialize = '''
command = "{}"
1. Initialize Coordinates
x = 0
y = 0
2. Main Loop'''
        self.one_iteration_U = '''
2.1 one iteration
```
for move in command:
```
move = 'U'
```
if move == 'U':
```
move == 'U'
enter
```
y += 1
```
y = {} + 1 = {}
```'''
        self.one_iteration_L = '''
2.1 one iteration
```
for move in command:
```
move = 'L'
```
if move == 'U':
```
move = 'L'
do not enter
```
elif move == 'L':
```
move == 'L'
enter
```
x -= 1
```
x = {} - 1 = {}
```'''
        self.one_iteration_R = '''
2.1 one iteration
```
for move in command:
```
move = 'R'
```
if move == 'U':
```
move = 'R'
do not enter
```
elif move == 'L':
```
move = 'R'
do not enter
```
elif move == 'R':
```
move == 'R'
enter
```
x += 1
```
x = {} + 1 = {}
```'''
        self.one_iteration_D = '''
2.1 one iteration
```
for move in command:
```
move = 'D'
```
if move == 'U':
```
move = 'D'
do not enter
```
elif move == 'L':
```
move = 'D'
do not enter
```
elif move == 'R':
```
move = 'D'
do not enter
```
elif move == 'D':
```
move == 'D'
enter
```
y -= 1
```
y = {} - 1 = {}
```'''
        self.return_result_true = '''
3. Return Result
```
if x == 0 and y == 0:
```
x = {}
y = {}
x == 0 and y == 0
enter
```
return True
```
return True
So the answer is Yes.'''
        self.return_result_false_x = '''
3. Return Result
```
if x == 0 and y == 0:
```
x = {}
y = {}
x != 0
do not enter
```
return False
```
return False
So the answer is No.'''
        self.return_result_false_y = '''    
3. Return Result
```
if x == 0 and y == 0:
```
x = {}
y = {}
y != 0
do not enter
```
return False
```
return False
So the answer is No.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length
        
        return {...}
        '''
        # example question: A robot is at position (0,0) and receives the command string "LRUDLR", where U means move up, L means move left, R means move right, and D means move down. Can the robot return to the origin? The way that the robot is facing is irrelevant.
        # example answer: Yes
        command = random.choices(["U", "L", "R", "D"], k=length) if length % 2 == 1 else random.choice(
            [random.choices(["U", "L", "R", "D"], k=length), random.choices(["UD", "LR"], k=length // 2)])
        random.shuffle(command)
        command = "".join(command)
        question = f"A robot is at position (0,0) and receives the command string \"{command}\", where U means move up, L means move left, R means move right, and D means move down. Can the robot return to the origin? The way that the robot is facing is irrelevant."
        gt = "Yes" if command.count('R') == command.count('L') and command.count('U') == command.count('D') else "No"
        return {"question": question,
                "gt": gt,
                "command": command}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data

        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        command = data["command"]
        x, y = 0, 0
        output = self.initialize.format(command)
        for move in command:
            if move == "U":
                y += 1
                output += self.one_iteration_U.format(y - 1, y)
            elif move == "L":
                x -= 1
                output += self.one_iteration_L.format(x + 1, x)
            elif move == "R":
                x += 1
                output += self.one_iteration_R.format(x - 1, x)
            elif move == "D":
                y -= 1
                output += self.one_iteration_D.format(y + 1, y)
        answer = "Yes" if x == 0 and y == 0 else "No"
        if x == 0 and y == 0:
            output += self.return_result_true.format(x, y)
        elif x != 0:
            output += self.return_result_false_x.format(x, y)
        elif y != 0:
            output += self.return_result_false_y.format(x, y)
        return {"input": input,
                "output": output,
                "answer": answer}
