import random
import numpy 

def generate_integer(length: int) -> str:
    min_ = 10 ** (length - 1) if length != 1 else 0
    return str(random.randint(min_, 10 ** length - 1))


def generate_float(length: int) -> str:
    int_digit = random.randint(1, length)
    int_part = random.randint(10 ** (int_digit - 1), 10 ** int_digit - 1)
    # int_part = random_rng.randint(0, 10 ** length - 1)
    dec_digit = length - int_digit
    if dec_digit >= 1:
        dec_part = [str(random.randint(0, 9)) for i in range(dec_digit-1)] + [str(random.randint(1,9))]
    else:
        dec_part = [str(random.randint(0,9))] # If there is only one digit, the last digit of decimal part can be zero
    return str(int_part) + '.' + ''.join(dec_part)

def calc_gcd(a: int, b: int) -> int:
    while b:
        a, b = b, a % b
    return a

def generate_fraction(length: int) -> str:
    """length: the number of digits in the denominator"""
    while True:
        num = random.randint(0, 10 ** length - 1)
        den = random.randint(10 ** (length - 1), 10 ** length - 1)
        gcd = calc_gcd(num, den)
        red_num = num // gcd
        red_den = den // gcd
        if len(str(red_den)) == length:
            break
    return str(red_num) + '/' + str(red_den)


def generate_scientific(length: int) -> str:
    float_int = random.randint(1, 9)
    float_dec = generate_float(length).split('.')[1]
    float_part = str(float_int) + '.' + str(float_dec)
    return float_part + 'e' + str(random.randint(0, length))


if __name__ == '__main__':
    print(generate_integer(4))
    print(generate_integer(4))
    print(generate_float(4))
    print(generate_fraction(4))
    print(generate_scientific(4))