import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 1598  
        self.name = 'Crawler Log Folder'
        self.description ='Find the final folder'
        self.url='https://leetcode.com/problems/crawler-log-folder/description/'
        self.question='''Q: Find the final folder after the operations (In the given list, '../' means back, './' means stay, 'x/' means move to x)    \n'''
        self.data='''The given operation is {0}\n'''
        self.instruction='''Follow the given rule to solve this problem.\nrule:'''
        self.rule='''def findDir(self, logs: List[str]) -> int:
    stack = []
    while logs:
        log = logs.pop(0)
        if log == './':
            continue
        if log == '../':
            if stack:
                stack.pop()
        else:
            stack.append(log[:-1])
    return '/'.join(stack)
'''
        self.initialize='''1. Initialize
logs = {}
stack = []
2. Main loop
'''
        self.enter = '''```
while logs:
```
logs = {}
enter the loop
2.1 One iteration
```
log = logs.pop(0)
```
logs = {}
log = '{}'
now,
logs = {}
'''
        self.not_enter = '''```
while logs:
```
logs = {}
do not enter
'''
        self.back = '''```
if log == './':
    continue
```
log = '../'
do not enter
```
if log == '../':
```
log = '../'
enter if
```
if stack:
    stack.pop()
```
stack = {}
now,
stack = {}
'''
        self.stay = '''```
if log == './':
    continue
```
log = './'
enter if
continue
'''
        self.move = '''```
if log == './':
    continue
```
log = '{}'
do not enter
```
if log == '../':
```
log = '{}'
do not enter
```
else:
    stack.append(log[:-1])
```
log = '{}'
stack = {}
now,
stack = {}
'''
        self.return_result='''```
return '/'.join(stack)
```
stack = {}
return '{}'
So the answer is '{}'
'''

    def gen_data_from_len(self, length: int) :
        database=['../','./']
        names = []
        with open('./names.txt', 'r') as f:
            for line in f:
                names.append(line.strip()+'/')
        logs = []
        depth = 0
        for i in range(length):
            if depth == 0:
                logs.append(random.choice(names))
            else:
                if random.random() < 0.5:
                    logs.append(random.choice(database))
                else:
                    logs.append(random.choice(names))
            if logs[-1] == '../':
                depth -= 1
            elif logs[-1] == './':
                pass
            else:
                depth += 1
        # print(logs, depth)
        return logs

    def rfft_IO(self, logs: list) -> int:
        input = self.instruction + self.rule + self.question + self.data.format(logs)
        stack = []
        output = self.initialize.format(logs)
        while logs:
            output += self.enter.format(logs, logs, logs[0], logs[1:])
            log = logs.pop(0)
            if log == "./":
                output += self.stay
                continue
            if log == "../":
                if stack:
                    output += self.back.format(stack, stack[:-1])
                    stack.pop()
                else:
                    output += self.back.format(stack, stack)
            else:
                output += self.move.format(log, log, log, stack, stack + [log[:-1]])
                stack.append(log[:-1])
        output += self.not_enter.format(logs)
        output += self.return_result.format(stack, "/".join(stack), "/".join(stack))
        return {'input': input, 'output': output, 'answer': "".join(stack)}
    
    def cot_IO(self, logs: list) -> dict:
        question = self.question + self.data.format(logs)
        output = ''
        output += f"logs = {logs}\n"
        stack = []
        for log in logs:
            if log == "./":
                output += f"'{log}' means stay in the current folder\n"
                continue
            elif log == "../":
                if stack:
                    output += f"'{log}' means back to the previous folder\n"
                    stack.pop()
                else:
                    output += f"'{log}' means back, but stack is empty\n"
            else:
                output += f"'{log}' means move to '{log[:-1]}'\n"
                stack.append(log[:-1])
            output += f"We are now at: \'{'/'.join(stack)}\'\n"
        answer = "/".join(stack)
        output += f"So the answer is '{answer}'\n"
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(4)
    data = dg.cot_IO(data)
    print(data['input'])
    print(data['output'])