import random
# random.seed(42)

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2544
        self.name = "Alternate Digit Sum"
        self.description = '''For a given number,change the alternate digit'sign and add up them'''
        self.url='https://leetcode.com/problems/alternating-digit-sum/description/'
        self.question='''Q: An list of positive integers, the most significant digit is assigned a positive sign. Each other digit has an opposite sign to its adjacent digits. Return their sum.\n'''
        self.data="The given integer is {}\n"
        self.instruction= "Follow the given rule to solve the question.\nrule: "
        self.rule='''

def alternateDigitSum(self, n: List) -> int:
    ans = 0
    sign = 1
    while n:
        first_digit = n[0]
        n = n[1:]
        ans += sign * first_digit
        sign = -sign
    return ans
'''
        self.initialize='''1.Initialize
ans = 0
sign = 1
n = {}
'''
        self.enter='''2.1 One iteration
```
while n:
```
n = {0}
enter the loop
'''
        self.not_enter='''2.1 One iteration
```
while n:
```
n = {0}
do not enter
'''     
        self.enter_inside='''```
first_digit = n[0]
n = n[1:]
```
n = {1}
first_digit = {0}
now,
n = {2}
```
ans += sign * first_digit
```
ans = {4}
sign = {3}
first_digit = {0}
ans = {4} + {3} * {0} = {5}
```
sign = -sign
```
sign = {3}
now,
sign = {6}
'''     
        self.ret='''```
return ans
```
ans = {0}
So the answer is {0}
'''
    def gen_data_from_len(self,length:int) -> int:
        '''
        return datapoint of given length
        '''
        data=0
        for i in range(length):
            n=random.randint(1,9)
            data+=n*10**i
        return data
    def rfft_IO(self, n: int) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input=self.instruction+self.rule + self.question+self.data.format(n)
        n = [int(x) for x in str(n)]  
        ans=0
        sign=1
        output = self.initialize.format(n)
        while n:
            output += self.enter.format(n)
            n1 = n[:]
            first_digit = int(n[0])
            n = n[1:]
            ans += sign * first_digit
            sign = -sign
            output += self.enter_inside.format(first_digit, n1, n, -sign, ans+sign*first_digit, ans, sign)
        output += self.not_enter.format(n)
        output += self.ret.format(ans)
         
            
        return {"input":input,
                "output":output,
                'answer':ans}
    def cot_IO(self, n: int) -> dict:
        question = self.question + self.data.format(",".join(str(n)))
        output = "Calculate the alternate digit sum:\n"
        output += f"n = {','.join(str(n))}\n"
        ans = 0
        sign = 1
        digits = list(str(n))
        
        # print(digits)
        sign = 1
        output += f'ans '
        for i in range(len(digits)):
            output += '= '
            sign = 1
            for d in digits[:-(i+1)]:
                o = f'{"" if sign==1 else "-"}{d}'
                if sign != 1: o = f"({o}) + "
                else: o = o + " + "
                output += o
                sign = -sign
            
            ans += int(digits[-i-1]) * sign
            # output += f'{str(ans)}\n'
            d = ans if ans > 0 else -ans
            sign = 1 if ans > 0 else 0
            o = f'{"" if sign==1 else "-"}{d}'
            if sign != 1: o = f"({o})"
            else: o = o
            output += o + "\n"
            
        answer = ans
        # print(output)
        output += f"So the answer is {answer}\n"
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(3)
    data = dg.rfft_IO(data)
    print(data['input'])
    print(data['output'])