import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 258
        self.name='Add Digits'
        self.description='Given an integer num, repeatedly add up all its digits until the result has only one digit.'
        self.url='https://leetcode.com/problems/add-digits/description/'
        self.data="The given intenger 'num' is {}\n"
        self.question="Q:Given an integer num, repeatedly add up all its digits until the result has only one digit, and return it.\n"
        self.instruction= "Follow the given rule to solve the question.\nrule: "
        self.rule='''

def add_digits(self, num: int) -> int:
    while num > 9:
        sum = 0
        while num:
            sum += num % 10
            num //= 10
        num = sum
    return num
'''
        self.initialize='''1. Initialize
num = {}
2. Outer loop
'''
        self.enter='''```
while num > 9:
```
num = {}
enter the loop
2.1 One iteration
'''
        self.not_enter='''```
while num > 9:
```
num = {}
do not enter
'''
        self.init_loop='''sum = 0
3. Inner loop
'''
        self.enter_loop='''```
while num:
```
num = {}
enter the loop
3.1 One iteration
'''
        self.not_enter_loop='''```
while num:
```
num = {}
do not enter
'''
        self.inner_loop='''```
sum += num % 10
num //= 10
```
num = {}
num % 10 = {}
sum = {}
now,
sum = {} + {} = {}
num = {} // 10 = {}
'''
        self.modify_num='''```
num = sum
```
sum = {}
now,
num = {}
'''
        self.return_ans='''4. Return
```
return num
```
num = {}
So the answer is {}
'''

        self.rule_nl = '''
Follow the rule to repeatedly sum all digits until the result is a single digit:

1. Begin outer loop:  
    2.1 Check whether the number is a single-digit number. If it is not, enter the outer loop; otherwise, the loop is over, go to step (2).  
    2.2 One iteration:  
        2.2.1 Initialize the sum of the digits of the number in this iteration as sum equals 0.  
        2.2.2 Begin inner loop:  
            2.2.2.1 Check whether the number is 0. If the number is not 0, enter the inner loop; otherwise, the loop is over, go to step (2.2.3).  
            2.2.2.2 One iteration:  
                2.2.2.2.1 Find the last digit of the number and add it to sum.  
                2.2.2.2.2 Remove the last digit from the number.  
            2.2.2.3 Return to the start of the inner loop (2.2.2.1).  
        2.2.3 After calculating the sum of all digits, update the number with the value of sum.  
    2.3 Return to the start of the outer loop (2.1).  
2. Return the remaining single-digit number.  
'''


    def gen_data_from_len(self, length: int) -> int:
        '''
        return datapoint of given length
        '''
        nums=0
        for i in range(0,length):
            num=random.randint(1,9)
            nums+=num*10**(i)
        return nums
        
    def rfft_IO(self, num: int) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input = self.instruction+self.rule + self.question+self.data.format(num)
        output = self.initialize.format(num)
        while num > 9:
            output += self.enter.format(num)
            sum = 0
            output += self.init_loop
            while num:
                output += self.enter_loop.format(num)
                output += self.inner_loop.format(num, num%10, sum, sum, num%10, sum + num%10, num, num//10)
                sum += num % 10
                num //= 10
            output += self.not_enter_loop.format(num)
            output += self.modify_num.format(sum,sum)
            num = sum
        output += self.not_enter.format(num)
        output += self.return_ans.format(num,num)
        answer = num
        return {"input":input,
                "output":output,
                "answer":answer}
    def natural_IO(self, num: int) -> dict:
        question = self.question + self.data.format(num)
        output = "# repeatedly add up all digits until the result has only one digit\n"
        output += f"num = {num}\n"
        while num > 9:
            sum = 0
            output += "# calculate the sum of digits of {num}\nsum = 0\n"
            while num:
                output += f"sum += {num%10}, sum = {sum+num%10}\n"
                sum += num % 10
                output += f"remaining num: {num//10}\n"
                num //= 10
            output += f"num = {sum}\n"
            num = sum
        output += f"So the answer is {num}\n"
        answer = num
        return {"input": question,
                "output": output,
                "answer": answer}
    
    def cot_IO(self, num: int) -> dict:
        question = self.question + self.data.format(num)
        output = ''
        output += f"num = {num}\n"
        while num > 9:
            sum = 0
            output += f"Calculate the sum of digits of {num}: "
            for d in str(num):
                if output[-2] != ':':
                    output += f" + {d}"
                else:
                    output += f"{d}"
                sum += int(d)

            output += f" = {sum}\n"
            num = sum
        output += f"So the answer is {num}\n"
        answer = num
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(3)
    # data = dg.rfft_IO(data)
    # print(data['input'])
    # print(data['output'])
    data = dg.cot_IO(data)
    print(data['input'])
    print(data['output'])