import random


class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 258
        self.name='Add Digits'
        self.description='Given an integer num, repeatedly add up all its digits until the result has only one digit.'
        self.url='https://leetcode.com/problems/add-digits/description/'
        self.data="The given intenger 'num' is {}\n"
        self.question="Q:Given an integer num, repeatedly add up all its digits until the result has only one digit, and return it.\n"
        self.instruction= "Follow the given rule to solve the question.\nrule: "
        self.rule = '''
Follow the rule to repeatedly sum all digits until the result is a single digit:

1. Begin outer loop:  
    1.1 Check whether the number is a single-digit number. If it is not, enter the outer loop; otherwise, the loop is over, go to step (2).  
    1.2 One iteration:  
        1.2.1 Initialize the sum of the digits of the number in this iteration as sum equals 0.  
        1.2.2 Begin inner loop to calculate the digit sum:  
            1.2.2.1 Check whether the number is 0. If the number is not 0, enter the inner loop; otherwise, the loop is over, go to step (1.2.3).  
            1.2.2.2 One iteration:  
                1.2.2.2.1 Find the last digit of the number and add it to sum.  
                1.2.2.2.2 Remove the last digit from the number.  
            1.2.2.3 Return to the start of the inner loop.  
        1.2.3 After calculating the sum of all digits, update the number with the value of sum.  
    1.3 Return to the start of the outer loop.  
2. Return the remaining single-digit number.  
'''
        self.init = '''0. The number is {}. Begin the process.
'''
        self.enter_outer_loop = '''```
1. Begin outer loop:
1.1 Check whether the number is a single-digit number. If it is not, enter the outer loop; otherwise, the loop is over, go to step (2).
```
The number is {}, which is not a single-digit number. Enter the outer loop.
'''
        self.not_enter_outer_loop = '''```
1. Begin outer loop:
1.1 Check whether the number is a single-digit number. If it is not, enter the outer loop; otherwise, the loop is over, go to step (2).
```
The number is {}, which is a single-digit number. The loop is over. Go to step (2).
'''
        self.init_outer_loop = '''1.2 One iteration:
1.2.1 Initialize the sum of the digits of the number in this iteration as sum equals 0.
```
Initialize sum = 0.
'''
        self.enter_inner_loop = '''```
1.2.2 Begin inner loop to calculate the digit sum:
1.2.2.1 Check whether the number is 0. If the number is not 0, enter the inner loop; otherwise, the loop is over, go to step (1.2.3).
```
The number is {}, which is not 0. Enter the inner loop.
'''
        self.not_enter_inner_loop = '''```
1.2.2 Begin inner loop to calculate the digit sum:
1.2.2.1 Check whether the number is 0. If the number is not 0, enter the inner loop; otherwise, the loop is over, go to step (1.2.3).
```
The number is 0. The loop is over. Go to step (1.2.3).
'''
        self.init_inner_loop = '''```
1.2.2.2 One iteration:
1.2.2.2.1 Find the last digit of the number and add it to sum.
```
number = {}, the last digit of the number is {}. Add it to sum, sum = {} + {} = {}.
'''
        self.modify_num = '''```
1.2.2.2.2 Remove the last digit from the number.
```
Remove the last digit from the number, number = {} // 10 = {}.
'''
        self.inner_loop_return = '''```
1.2.2.3 Return to the start of the inner loop.
```
Back to the start of the inner loop.
'''
        self.outer_loop_return = '''```
1.3 Return to the start of the outer loop.
```
Back to the start of the outer loop.
'''
        self.update_num = '''```
1.2.3 After calculating the sum of all digits, update the number with the value of sum.
```
sum = {}. Update the number with the value of sum, so number is {} now.
'''
        self.return_ans = '''```
2. Return the remaining single-digit number.
```
The number is {}. So the answer is {}.
'''        


    def gen_data_from_len(self, length: int) -> int:
        '''
        return datapoint of given length
        '''
        nums=0
        for i in range(0,length):
            num=random.randint(1,9)
            nums+=num*10**(i)
        return nums
        
    def rfft_IO(self, num: int) -> int:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        input = self.instruction+self.rule + self.question+self.data.format(num)
        output = ''
        output += self.init.format(num)
        while num > 9:
            output += self.enter_outer_loop.format(num)
            sum = 0
            output += self.init_outer_loop
            while num:
                output += self.enter_inner_loop.format(num)
                output += self.init_inner_loop.format(num, num%10, sum, num%10, sum + num%10)
                sum += num % 10
                output += self.modify_num.format(num, num//10)
                num //= 10
                output += self.inner_loop_return
            output += self.not_enter_inner_loop
            output += self.update_num.format(sum, sum)
            num = sum
            output += self.outer_loop_return
        output += self.not_enter_outer_loop.format(num)
        output += self.return_ans.format(num,num)
        answer = num
        return {"input":input,
                "output":output,
                "answer":answer}

    
    def cot_IO(self, num: int) -> dict:
        question = self.question + self.data.format(num)
        output = ''
        output += f"num = {num}\n"
        while num > 9:
            sum = 0
            output += f"Calculate the sum of digits of {num}: "
            for d in str(num):
                if output[-2] != ':':
                    output += f" + {d}"
                else:
                    output += f"{d}"
                sum += int(d)

            output += f" = {sum}\n"
            num = sum
        output += f"So the answer is {num}\n"
        answer = num
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(3)
    # data = dg.rfft_IO(data)
    # print(data['input'])
    # print(data['output'])
    data = dg.rfft_IO(data)
    print(data['input'])
    print(data['output'])