import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 2677
        self.name = "Chunk_Array"
        self.description = '''Given an array arr and a chunk size size, what's a chunked array.'''
        self.url = '''https://leetcode.com/problems/chunk-array/description/'''
        self.rule = '''
def Chunk_Array(arr: list, size: int) -> list:
    result = []
    while arr:
        j = 0
        tmp = []
        while j < size and arr:
            num = arr.pop(0)
            tmp.append(num)
            j += 1
        result.append(tmp)
    return result
'''
        self.initialize = '''arr = {}
size = {}
'''
        self.enter = '''```
while arr:
```
arr = {}
enter the loop
'''
        self.not_enter = '''```
while arr:
```
arr = {}
do not enter
'''
        self.init_iteration = '''j = 0
tmp = []
'''
        self.enter2 = '''```
while j < size and arr:
```
j = {}
size = {}
arr = {}
enter the loop
'''
        self.not_enter2 = '''```
while j < size and arr:
```
j = {}
size = {}
arr = {}
do not enter
'''
        self.get_num = '''```
num = arr.pop(0)
```
arr = {}
num = {}
now,
arr = {}
'''
        self.append_num = '''```
tmp.append(num)
```
tmp = {}
num = {}
now,
tmp = {}
'''
        self.append_tmp = '''```
result.append(tmp)
```
result = {}
tmp = {}
now,
result = {}
'''
        self.addj = '''```
j += 1
```
j = {} + 1 = {}
'''
        self.return_result = '''```
return result
```
result = {}
So the answer is {}
'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","arr","size"
        '''
        arr = []
        for i in range(length):
            arr.append(random.randint(1,100))
        size = min(length, random.randint(1, length))
        question = f"arr = {arr}, size = {size}. What's the chunked array?"
        return {"question": question,
                "arr": arr,
                "size": size}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        arr = data["arr"]
        size = data["size"]
        output = self.initialize.format(arr, size)
        result = []
        while arr:
            output += self.enter.format(arr)
            j = 0
            tmp = []
            output += self.init_iteration
            while j < size and arr:
                output += self.enter2.format(j, size, arr)
                output += self.get_num.format(arr, arr[0], arr[1:])
                num = arr.pop(0)
                output += self.append_num.format(tmp, num, tmp + [num])
                tmp.append(num)
                output += self.addj.format(j, j+1)
                j += 1
            output += self.not_enter2.format(j, size, arr)
            output += self.append_tmp.format(result, tmp, result + [tmp])
            result.append(tmp)
        output += self.not_enter.format(arr)
        output += self.return_result.format(result, result)
        answer = result
        return {"input": input,
                "output": output,
                "answer":answer}
        
    def cot_IO(self, data: dict) -> dict:
        question = data["question"]
        arr = data["arr"]
        size = data["size"]
        output = ''
        output += f"arr = {arr}\nsize = {size}\n"
        result = []
        cnt = 0
        while arr:
            cnt += 1
            tmp = []
            for _ in range(size):
                if arr:
                    tmp.append(arr.pop(0))
            result.append(tmp)
            output += f"first chunk: {tmp}\n" if cnt == 1 else f"next chunk: {tmp}\n"
        answer = result
        output += f"So the answer is {result}\n"
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(30)
    data = dg.cot_IO(data)
    print(data['input'])
    print(data['output'])
    # file = open("tasks/2677.json", "w")
    # file.write(data['input'] + data['output'] + str(data['answer']))