import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 283  
        self.name =  'move_zeros'  
        self.description = "move all zeros to the end of the array"  
        self.url = "https://leetcode.com/problems/move-zeroes/description/"
         
        self.rule = '''
def moveZeros(nums):
    num_zero = 0
    result = []
    while nums:
        number = nums.pop(0)
        if number != 0:
            result.append(number)
        else:
            num_zero += 1
    i = 0
    while i < num_zero:
        result.append(0)
        i += 1
    return result
'''
        self.initialize = '''1. Initialize
nums = {}
num_zero = 0
result = []
2. Main loop
'''
        self.enter1 = '''```
while nums:
```
nums = {}
enter the loop
2.1 One iteration
'''
        self.not_enter1 = '''```
while nums:
```
nums = {}
do not enter
'''
        self.get_num = '''```
number = nums.pop(0)
```
nums = {}
number = {}
now,
nums = {}
'''
        self.if1_enter = '''```
if number != 0:
    result.append(number)
```
number = {}
enter if
result = {}
now,
result = {}
'''
        self.if1_not_enter = '''```
if number != 0:
    result.append(number)
```
number = {}
do not enter
```
else:
    num_zero += 1
```
num_zero = {} + 1 = {}
'''
        self.loop2 = '''i = 0
3. Loop2
'''
        self.enter2 = '''```
while i < num_zero:
```
i = {}
num_zero = {}
enter the loop
3.1 One iteration
'''
        self.not_enter2 = '''```
while i < num_zero:
```
i = {}
num_zero = {}
do not enter
'''
        self.append_zero = '''```
result.append(0)
i += 1
```
result = {}
i = {}
now,
result = {}
i = {} + 1 = {}
'''
        self.return_result = '''4. Return result
```
return result
```
result = {}
So the answer is {}
'''


    def gen_data_from_len(self, length: int) -> dict:
        nums = random.choices([0 for i in range(10)]+[i for i in range(20)], k = length)
        question = f'An integer array nums is {nums}, move all 0 to the end of it while maintaining the relative order of the non-zero elements.'
        non_zero = 0
        nums_bk = nums.copy()
        for i in range(len(nums)):
            if nums[i] != 0:
                nums[i], nums[non_zero] = nums[non_zero], nums[i]
                non_zero += 1
        return {"question": question, 
                "gt": nums,
                "nums": nums_bk}
        
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ:" + data["question"]
        nums = data["nums"]
        output = self.initialize.format(nums)
        
        num_zero = 0
        result = []
        while nums:
            output += self.enter1.format(nums)
            output += self.get_num.format(nums, nums[0], nums[1:])
            number = nums.pop(0)
            if number != 0:
                output += self.if1_enter.format(number, result, result + [number])
                result.append(number)
            else:
                output += self.if1_not_enter.format(number, num_zero, num_zero + 1)
                num_zero += 1
        output += self.not_enter1.format(nums)
        output += self.loop2
        i = 0
        while i < num_zero:
            output += self.enter2.format(i, num_zero)
            output += self.append_zero.format(result, i, result + [0], i, i + 1)
            result.append(0)
            i += 1
        output += self.not_enter2.format(i, num_zero)
        output += self.return_result.format(result, result)
        
        answer = result
        return {"input": input, 
                "output": output,
                "answer": answer}
        
    def natural_IO(self, data: dict) -> dict:
        question = data["question"]
        nums = data["nums"]
        output = ''
        output += f"nums = {nums}\n"
        num_zero = 0
        result = []
        for d in nums:
            if d != 0:
                output += f"{d} is not zero, append it to the result\n"
                result.append(d)
                output += f"result = {result}\n"
            else:
                num_zero += 1
                output += f"{d} is zero, num_zero = {num_zero}\n"
        for i in range(num_zero):
            result.append(0)
            output += f"append 0 to the result, result = {result}\n"
        output += f"So the answer is {result}\n"
        answer = result
        return {"input": question,
                "output": output,
                "answer": answer}
    
    def cot_IO(self, data: dict) -> dict:
        question = data["question"]
        nums = data["nums"]
        output = ''
        output += f"nums = {nums}\n"
        num_zero = 0
        result = []
        non_zero = [x for x in nums if x != 0]
        zeros = [0 for x in nums if x == 0]
        output += f'Separate non-zero elements from zero elements:\nNon-zero elements:\n{non_zero}\nZero elements:\n{zeros}\n'
        output += f'Concatenate non-zero elements and zero elements to get the answer.\n'
        result = non_zero + zeros
        output += f"So the answer is {result}\n"
        answer = result
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(4)
    data = dg.cot_IO(data)
    print(data['input'], '\n')
    print(data['output'])