import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 3324
        self.name = 'stringSequence'
        self.description = 'Key 1 appends the character "a" to the string on the screen. Key 2 changes the last character of the string on the screen to its next character in the English alphabet. Return a list of all strings that appear on the screen as Alice types target, in the order they appear, using the minimum key presses.'
        self.url = 'https://leetcode.com/problems/find-the-sequence-of-strings-appeared-on-the-screen/'

        self.rule = '''
def stringSequence(self, target: str) -> list[str]:
    s = []
    ans = []
    target = list(target)
    while target:
        i = 0
        tar = target.pop(0)
        s.append('')
        while 1:
            if s[-1] == tar:
                break
            s[-1] = string.ascii_lowercase[i]
            ans.append(''.join(s))
            i += 1
    return ans'''
        self.initialize = '''
1. Initialize
s = []
ans = []
```
target = list(target)
```
target = {}
2. Main loop'''
        self.interation_outer = '''
2.{} one iteration
```
while target:
```
target = {}
enter the loop
i = 0
```
tar = target.pop(0)
```
target = {}
tar = '{}'
now,
target = {}
```
s.append('')
```
s = {}
now,
s = {}'''
        self.interation_inner_in = '''
2.{}.{} one iteration
```
while 1:
```
enter the loop
```
if s[-1] == tar:
    break
```
s = {}
s[-1] = '{}'
tar = '{}'
s[-1] == tar
enter if
break
```'''
        self.interation_inner_not_in = '''
2.{}.{} one iteration
```
while 1:
```
enter the loop
```
if s[-1] == tar:
    break
```
s = {}
s[-1] = '{}'
tar = '{}'
s[-1] != tar
do not enter
```
s[-1] = string.ascii_lowercase[i]
```
s = {}
i = {}
string.ascii_lowercase[i] = '{}'
now,
s = {}
```
ans.append(''.join(s))
```
s = {}
ans = {}
now,
ans = {}
```
i += 1
```
i = {} + 1 = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while target:
```
target = {}
do not enter'''
        self.return_result = '''
3. Return result
```
return ans
```
So the answer is {}.'''



    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        import string
        target = ''
        remain = length
        for _ in range(length):
            target += random.choice(string.ascii_lowercase[:remain])
            remain -= ord(target[-1]) - 96
            if remain == 0:
                break
        
        question = f'''target = "{target}". Key 1 appends the character "a" to the string on the screen. Key 2 changes the last character of the string on the screen to its next character in the English alphabet. Return a list of all strings that appear on the screen as Alice types target, in the order they appear, using the minimum key presses.'''
        return {"question": question,
                "target": target}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        import string
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        question = data["question"]
        input = instruction + rule + "\n\nQ: " + question
        target = data["target"]
        s = []
        ans = []
        target = list(target)
        output = self.initialize.format(target)
        j = 1
        while target:
            target_copy = deepcopy(target)
            i = 0
            tar = target.pop(0)
            s.append('')
            output += self.interation_outer.format(j,target_copy,target_copy, tar,target,s[:-1],s)
            m = 1
            while 1:
                if s[-1] == tar:
                    output += self.interation_inner_in.format(j,m,s,s[-1],tar)
                    break
                else:
                    tt = deepcopy(s)
                    tt[-1] = string.ascii_lowercase[i]
                    output += self.interation_inner_not_in.format(j,m,s,s[-1],tar,s,i,string.ascii_lowercase[i], tt,tt,ans,ans +[''.join(tt)],i,i+1)
                    s[-1] = string.ascii_lowercase[i]
                    ans.append(''.join(s))
                    i += 1
                m += 1
            j += 1
        if not target:
            output += self.not_enter_loop.format(j,target)
        output += self.return_result.format(ans)
        answer = ans
        return {"input": input,
                "output": output,
                "answer": answer}
    
    def cot_IO(self, data: dict) -> dict:
        import string
        question = data['question'] 
        output = ""
        target = data["target"]
        s = ''
        ans = []
        output += f"target = {target}\n"
        while target != s:
            s += 'a'
            ans.append(s)
            # print(s, target)
            output += f"type key 1, s = {s}, ans = {ans}\n"
            i = 1
            while s != target[:len(s)]:
                s = s[:-1] + string.ascii_lowercase[i]
                ans.append(s)
                output += f"type key 2, s = {s}, ans = {ans}\n"
                i += 1
        output += f"So the answer is {ans}\n"
        answer = ans
        return {"input": question,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(3)
    data = dg.rfft_IO(data)
    print(data['input'])
    print(data['output'])