# Learning with Instance-Dependent Label Noise: A Sample Sieve Approach
This code is a PyTorch implementation of the paper "Learning with Instance-Dependent Label Noise: A Sample Sieve Approach" submitted anonymously to ICLR2021.

The code is run on the Tesla V-100.
## Prerequisites
Python 3.6.9

PyTorch 1.2.0

Torchvision 0.4.a0


## Steps on Runing CORES on CIFAR 10
###Step 1: 

Download the datset from http://www.cs.toronto.edu/~kriz/cifar.html. Put the dataset on data/

### Step 2:

Run CORES (Phase 1: Sample Sieve) on the CIFAR-10 with instance 0.4 noise:

```
CUDA_VISIBLE_DEVICES=0 python phase1.py --loss cores --dataset cifar10 --model resnet --noise_type instance --noise_rate 0.4
```
### Step 3:
Run CORES (Phase 2: Consistency Training) on the CIFAR-10 with instance 0.4 noise:

```
cd phase2
CUDA_VISIBLE_DEVICES=0,1 python phase2.py -c confs/resnet34_ins_0.4.yaml --unsupervised
```
**Both Step 2 and Step 3 do not need pre-trained model.**