Task1_path=DetectRL/Benchmark/Tasks/Task1

methods='RM'
tasks='multi_domain multi_llms multi_attack human_writing'

# base_models='OpenAssistant/reward-model-deberta-v3-large-v2'
base_models='Ray2333/GRM-gemma2-2B-rewardmodel-ft'
benchmark=detectrl

model_path=YOUR_MODEL_PATH


for method in $methods
do
    for task in $tasks
    do
        if [ $task = 'multi_domain' ]; then
            test_data_path=$Task1_path/multi_domains_arxiv_test.json,$Task1_path/multi_domains_xsum_test.json,$Task1_path/multi_domains_writing_prompt_test.json,$Task1_path/multi_domains_yelp_review_test.json,
        elif [ $task = 'multi_llms' ]; then
            test_data_path=$Task1_path/multi_llms_ChatGPT_test.json,$Task1_path/multi_llms_Claude-instant_test.json,$Task1_path/multi_llms_Google-PaLM_test.json,$Task1_path/multi_llms_Llama-2-70b_test.json,
        elif [ $task = 'multi_attack' ]; then
            test_data_path=DetectRL/Benchmark/Benchmark_Data/Direct_Prompt/direct_prompt_test.json,DetectRL/Benchmark/Benchmark_Data/Prompt_Attacks/prompt_attacks_llm_test.json,DetectRL/Benchmark/Benchmark_Data/Paraphrase_Attacks/paraphrase_attacks_llm_test.json,DetectRL/Benchmark/Benchmark_Data/Perturbation_Attacks/perturbation_attacks_llm_test.json,DetectRL/Benchmark/Benchmark_Data/Data_Mixing/data_mixing_attacks_test.json,
        elif [ $task = 'human_writing' ]; then
            test_data_path=DetectRL/Benchmark/Tasks/Task4/direct_prompt_test.json,DetectRL/Benchmark/Tasks/Task4/paraphrase_attacks_human_test.json,DetectRL/Benchmark/Tasks/Task4/perturbation_attacks_human_test.json,DetectRL/Benchmark/Tasks/Task4/data_mixing_attacks_test.json,
        fi

        for base_model in $base_models
        do
            echo $method $task $base_model

            python IRM-detection/python/single_model.py \
                --method ${method} \
                --test_data_path $test_data_path \
                --benchmark $benchmark \
                --base_model $model_path/$base_model \
                --save_path results/$benchmark/${task}/${method}/$base_model \
                --device 2,2
        done
    done
done