from agents.value_flows import ValueFlowsAgent
from agents.fql import FQLAgent
from agents.ifql import IFQLAgent
from agents.sql import SQLAgent
from agents.iql import IQLAgent
from agents.iqn import IQNAgent
from agents.fbrac import FBRACAgent
from agents.bc import BCAgent
from agents.mc_fdrl import MCFDRLAgent
from agents.rebrac import ReBRACAgent
from agents.sac import SACAgent

agents = dict( 
    value_flows=ValueFlowsAgent, 
    fql=FQLAgent,
    iqn=IQNAgent, 
    ifql=IFQLAgent,
    fbrac=FBRACAgent, 
    bc=BCAgent, 
    iql=IQLAgent,
    sql=SQLAgent,
    mc_fdrl=MCFDRLAgent,
    rebrac=ReBRACAgent,
    sac=SACAgent,
)
