# GTR-Loc: Geospatial Text Regularization Assisted Outdoor LiDAR Localization

---

## Requirements
- python 3.9.17

- pytorch 2.0.1

- MinkowskiEngine 0.5.4

## Datasets

GTR-Loc currently supports the following datasets:
- Oxford Radar RobotCar
- QEOxford
- NCLT

We organize the dataset directories as follows:

- Oxford/QEOxford
```
data_root
├── 2019-01-11-14-02-26-radar-oxford-10k
│   ├── velodyne_left
│   │   ├── xxx.bin
│   │   ├── xxx.bin
│   │   ├── …
│   ├── velodyne_left_calibrateFalse.h5
│   ├── velodyne_left_False.h5
├── …
```
- NCLT
```
data_root
├── 2012-01-22
│   ├── velodyne_left
│   │   ├── xxx.bin
│   │   ├── xxx.bin
│   │   ├── …
    ├── velodyne_sync
│   │   ├── xxx.bin
│   │   ├── xxx.bin
│   │   ├── …
│   ├── velodyne_left_False.h5
├── …
```

## Train (Following LightLoc)

We follow LightLoc to train the network. Download the nuScenes.pth from LightLoc into ckpt.

#### Oxford/QEOxford

- Train classifier (follow LightLoc)
```
python train.py --sample_cls=True --generate_clusters=True --batch_size=512 --epochs=50 --level_cluster=25
```
- Train regressor (follow LightLoc)
```
python train.py --sample_cls=False --generate_clusters=False --batch_size=256 --epochs=25 --rsd=True --level_cluster=25
```

#### NCLT

- Train classifier (follow LightLoc)
```
python train.py --sample_cls=True --generate_clusters=True --batch_size=512 --epochs=50 --level_cluster=100 --training_buffer_size=120000 --voxel_size=0.3
```
- Train regressor (follow LightLoc)
```
python train.py --sample_cls=False --generate_clusters=False --batch_size=256 --epochs=30 --rsd=True --prune_ratio=0.15 --level_cluster=100 --voxel_size=0.3
```
## Test
####  (QE)Oxford
```
python eval.py
```
####  NCLT
```
python eval.py --voxel_size=0.3
```
**Note:** For results matching Table 3 in the paper, exclude lines 4300–4500 from the 2012-05-26 trajectory.
