import torch
import math
from torch.autograd import Variable
import numpy as np
from torch.nn.utils import parameters_to_vector

def get_params(model):
    """
    get model parameters
    """
    params = []
    for param in model.parameters():
        if not param.requires_grad:
            continue
        params.append(param)
    return params

def get_grad(model):
    """
    get model parameters and gradients
    """
    grads = []
    for param in model.parameters():
        if not param.requires_grad:
            continue
        grads.append(0. if param.grad is None else param.grad + 0.)
    return grads

def get_params_grad(model):
    """
    get model parameters and gradients
    """
    params = []
    grads = []
    for param in model.parameters():
        if not param.requires_grad:
            continue
        params.append(param)
        grads.append(0. if param.grad is None else param.grad + 0.)
    return params, grads

        
def AgA_Grad_share(losses,loss_jt, policy, l=50, sign_flag=True):
    """
    AgA gradient adjustment
    
    """
    # We will open the implementation after the paper is accepted
    