from dataclasses import dataclass, asdict
from ..zipformer.model_config import ZipformerConfig

@dataclass
class ZipformerForSequenceClassificationConfig(ZipformerConfig):
    name: str = 'zipformer-tag'
    fuse_encoder: bool = False
    is_multilabel: bool = False
    
    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        # Define preset values
        presets = {
            "base": {
                **asdict(ZipformerConfig.from_preset("base"))
                },
            "large": {
                **asdict(ZipformerConfig.from_preset("large"))
            }
        }
        if preset not in presets:
            raise ValueError(f"Unsupported preset '{preset}' for {cls.__name__}. Supported: {list(presets.keys())}")
        # Build the full config
        config_dict = presets[preset].copy()
        config_dict.update({"name": "zipformer-tag"})
        config_dict.update(kwargs)
        return cls(**config_dict)