from dataclasses import dataclass
from ..audio_tag.model_config import ZipformerForSequenceClassificationConfig

@dataclass
class ZipformerForMusicTaggingConfig(ZipformerForSequenceClassificationConfig):
    name: str = 'zipformer-music'
    fuse_encoder: bool = False
    is_multilabel: bool = False
    evaluate_key: bool = False
    
    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        config = super().from_preset(preset, **kwargs)
        config.name = "zipformer-music"
        return config