from dataclasses import dataclass, asdict
from ..audio_tag.model_config import ZipformerForSequenceClassificationConfig
from typing import Optional

# Inherit from audio_tag config
@dataclass
class ZipformerForSpeakerIdentificationConfig(ZipformerForSequenceClassificationConfig):
    name: str = 'zipformer-spkid'
    loss_type: str = "ce"
    # used if loss_type is margin-based
    margin: Optional[float] = None      
    scale: Optional[float] = None       

    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        parent_config_instance = super().from_preset(preset)
        config_dict = asdict(parent_config_instance)
        config_dict.update({"name": "zipformer-spkid"})
        config_dict.update(kwargs)
        return cls(**config_dict)


