from dataclasses import dataclass, asdict
from typing import Optional
from ..asr.model_config import ZipformerForAsrConfig

@dataclass
class ZipformerForTtaConfig(ZipformerForAsrConfig):
    name: str = 'zipformer-tta'
    use_attention_decoder: bool = False
    vocab_size: int = 19763
    special_tokens: Optional[str] = None
    translate_mode: str = 'src2tgt'

    use_s2t_alignment: bool = False
    text_embed_model: str = "bert-base-multilingual-uncased"

    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        presets = {
            "base": {
                **asdict(ZipformerForAsrConfig.from_preset("base")),
                "name": "zipformer-tta",
            },
            "large": {
                **asdict(ZipformerForAsrConfig.from_preset("large")),
                "name": "zipformer-tta",
            }
        }

        if preset not in presets:
            raise ValueError(
                f"Unsupported preset '{preset}' for {cls.__name__}. "
                f"Supported: {list(presets.keys())}"
            )

        config_dict = presets[preset].copy()
        config_dict.update(kwargs)
        return cls(**config_dict)

