#!/bin/bash
export PYTHONPATH=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden:$PYTHONPATH

# train a VANILLA audio captioning model completely from scratch, batch size 6400, lr 5e-3, fp16
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
torchrun --nproc_per_node=8 \
        --master_port=29503 \
        train.py \
        exp_dir=exp/wavcaps_captioning_Au_Tu_5e-3_fp16_bsz6400 \
        data.train_data_config=configs/wavcaps/train_data_config_wavcaps.yaml \
        data.max_duration=800 \
        data.valid_sets='[/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_captioning/manifests/audiocaps_val.jsonl.gz]' \
        data.use_infinite_dataset=true \
        data.num_workers=12 \
        trainer.use_fp16=true \
        trainer.lr_steps_per_epoch=5000 \
        trainer.base_lr=0.005 \
        trainer.warmup_batches=20000 \