from dataclasses import dataclass, asdict
from typing import Optional
from ..zipformer.model_config import ZipformerConfig

@dataclass
class ZipformerForAsrConfig(ZipformerConfig):
    name: str = 'zipformer-asr'
    decoder_dim: int = 512
    context_size: int = 2
    joiner_dim: int = 512
    use_transducer: bool = True
    use_ctc: bool = False
    tokenizer_type: str = 'asr-spm'

    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        presets = {
            "base": {
                **asdict(ZipformerConfig.from_preset("base")),
                "name": "zipformer-asr",
            },
            "large": {
                **asdict(ZipformerConfig.from_preset("large")),
                "name": "zipformer-asr",
            }
        }

        if preset not in presets:
            raise ValueError(
                f"Unsupported preset '{preset}' for {cls.__name__}. "
                f"Supported: {list(presets.keys())}"
            )

        config_dict = presets[preset].copy()
        config_dict.update(kwargs)
        return cls(**config_dict)

