#!/bin/bash
export PYTHONPATH=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden:/apdcephfs_cq12/share_302080740/user/raytseng/research/lhotse:$PYTHONPATH

pretrained_model_checkpoint=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_clap/exp/CaptionStew_Full_CLAP_AU_TU_5e-3_fp16_bsz5120_shuffled_warmup/checkpoint-200000.pt
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node=8 \
        --master_port=29603 \
        train.py \
        exp_dir=evaluation_exp/evaluation_CaptionStew_Full_CLAP_TUAU_200k_1e-2_bsz5120_MeanPooling \
        ++model.config.text_encoder_type="roberta-base" \
        data.train_data_config=configs/audiocaps/train_data_config_audiocaps.yaml \
        data.max_duration=640 \
        data.valid_sets='[/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_captioning/manifests/audiocaps_test.jsonl.gz]' \
        data.use_infinite_dataset=true \
        data.num_workers=12 \
        trainer.lr_steps_per_epoch=100 \
        trainer.base_lr=0.01 \
        trainer.valid_interval=100 \
        trainer.save_every_n=1 \
        trainer.initialization.checkpoint=$pretrained_model_checkpoint \
        trainer.initialization.init_modules='[encoder_embed, encoder, text_encoder]' \

# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python3 /apdcephfs_cq12/share_302080740/user/raytseng/run_gpu.py --size 40000 --gpus 8 --interval 0.01