#!/bin/bash
export PYTHONPATH=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden:$PYTHONPATH

# # ----------------train from scratch ------------------
# export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
# torchrun --nproc_per_node=4 \
#         train.py \
#         exp_dir=exp/emotion_scratch_noRAVDESS \
#         model.id2label_json=configs/emotion/id2label_emotion.json \
#         data.train_data_config=configs/emotion/train_data_config.yaml \
#         data.max_duration=300 \
#         data.use_infinite_dataset=true \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \


# # ----------------train from asr init ------------------
# pretrained_checkpoint=/apdcephfs_cq10/share_1603164/user/yiwenyshao/independent/auden/egs/asr/exp/auden_zh_r3large_full_8gpu/averaged_iter1412000_avg10.pt
# export CUDA_VISIBLE_DEVICES=4,5,6,7
# torchrun --nproc_per_node=4 \
#         train.py \
#         exp_dir=exp/emotion_asr_init \
#         model.id2label_json=configs/emotion/id2label_emotion.json \
#         +model.config_preset=large \
#         data.train_data_config=configs/emotion/train_data_config.yaml \
#         data.max_duration=300 \
#         data.use_infinite_dataset=true \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \
#         trainer.base_lr=0.0045 \
#         trainer.initialization.checkpoint=$pretrained_checkpoint \


# # # ----------------train on ONE dataset for linear probing: init and freeze------------------
pretrained_model_checkpoint=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_captioning/exp/CaptionStew_400k_masked_captioning_AU_TU_5e-3_fp16_bsz5120_shuffled/checkpoint-25000.pt
CUDA_VISIBLE_DEVICES=4 torchrun --nproc_per_node=1 \
        --master_port=29504 \
        train.py \
        exp_dir=/apdcephfs_cq10_1603164/share_1603164/user/raytseng/research/exp/emotion/cremad_CaptionStew_400k_captioningPa_TUAU_25k_4_5e-3_bsz320_MeanPooling \
        model.id2label_json=configs/emotion/id2label_emotion_CREMA.json \
        data.train_data_config=configs/emotion/train_data_config_CREMA.yaml \
        data.max_duration=320 \
        data.use_infinite_dataset=true \
        data.valid_sets='[/apdcephfs_cq12/share_302080740/user/raytseng/data/CREMA-D/manifest/CREMA_valid_new.jsonl.gz]' \
        trainer.use_fp16=false \
        trainer.lr_steps_per_epoch=50 \
        trainer.base_lr=0.0045 \
        trainer.initialization.checkpoint=$pretrained_model_checkpoint \
        trainer.freeze_modules='[encoder_embed, encoder]' \
        trainer.valid_interval=50 \
